/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fastq;

import com.milaboratory.core.io.CompressionType;
import com.milaboratory.core.io.sequence.PairedRead;
import com.milaboratory.core.io.sequence.PairedSequenceWriter;
import com.milaboratory.core.io.sequence.fastq.QualityFormat;
import com.milaboratory.core.io.sequence.fastq.SingleFastqWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class PairedFastqWriter
implements PairedSequenceWriter {
    SingleFastqWriter[] writers;

    public PairedFastqWriter(File file1, File file2) throws IOException {
        this(new SingleFastqWriter(file1), new SingleFastqWriter(file2));
    }

    public PairedFastqWriter(String file1, String file2) throws IOException {
        this(new SingleFastqWriter(file1), new SingleFastqWriter(file2));
    }

    public PairedFastqWriter(String file1, String file2, QualityFormat qualityFormat, CompressionType ct) throws IOException {
        this(new SingleFastqWriter(new FileOutputStream(file1), qualityFormat, ct, 131072), new SingleFastqWriter(new FileOutputStream(file2), qualityFormat, ct, 131072));
    }

    public PairedFastqWriter(SingleFastqWriter writer1, SingleFastqWriter writer2) {
        this.writers = new SingleFastqWriter[]{writer1, writer2};
    }

    @Override
    public void write(PairedRead read) {
        this.writers[0].write(read.getR1());
        this.writers[1].write(read.getR2());
    }

    @Override
    public void flush() {
        RuntimeException ex = null;
        for (SingleFastqWriter writer : this.writers) {
            try {
                writer.flush();
            }
            catch (RuntimeException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public void close() {
        RuntimeException ex = null;
        for (SingleFastqWriter writer : this.writers) {
            try {
                writer.close();
            }
            catch (RuntimeException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

