/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fastq;

public enum QualityFormat {
    Phred33(33, 0, 50, "phred33"),
    Phred64(64, 0, 41, "phred64");

    private byte offset;
    private byte minValue;
    private byte maxValue;
    private String name;

    private QualityFormat(byte offset, byte minValue, byte maxVaule, String name) {
        this.offset = offset;
        this.minValue = minValue;
        this.maxValue = maxVaule;
        this.name = name;
    }

    public byte getMinValue() {
        return this.minValue;
    }

    public byte getMaxValue() {
        return this.maxValue;
    }

    public byte getOffset() {
        return this.offset;
    }

    public static QualityFormat fromName(String name) {
        switch (name.toLowerCase()) {
            case "phred33": {
                return Phred33;
            }
            case "phred64": {
                return Phred64;
            }
        }
        throw new IllegalArgumentException("Unknown quality format: " + name + ".");
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

