/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fastq;

import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReader;
import com.milaboratory.core.io.sequence.fastq.FastqRecordsReader;
import com.milaboratory.core.io.sequence.fastq.QualityFormat;
import com.milaboratory.core.io.util.AbstractRandomAccessReader;
import com.milaboratory.core.io.util.FileIndex;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class RandomAccessFastqReader
extends AbstractRandomAccessReader<SingleRead>
implements SingleReader,
AutoCloseable {
    private final QualityFormat qualityFormat;
    private final FastqRecordsReader recordsReader;

    public RandomAccessFastqReader(String file, String fileIndex) throws IOException {
        this(new RandomAccessFile(file, "r"), FileIndex.read(fileIndex), false, true);
    }

    public RandomAccessFastqReader(String file, String fileIndex, boolean replaceWildcards) throws IOException {
        this(new RandomAccessFile(file, "r"), FileIndex.read(fileIndex), replaceWildcards, true);
    }

    public RandomAccessFastqReader(String file, String fileIndex, boolean replaceWildcards, boolean lazyReads) throws IOException {
        this(new RandomAccessFile(file, "r"), FileIndex.read(fileIndex), replaceWildcards, lazyReads);
    }

    public RandomAccessFastqReader(File file, FileIndex fileIndex, boolean replaceWildcards, boolean lazyReads) throws FileNotFoundException {
        this(new RandomAccessFile(file, "r"), fileIndex, replaceWildcards, lazyReads);
    }

    public RandomAccessFastqReader(RandomAccessFile file, FileIndex fileIndex, boolean replaceWildcards, boolean lazyReads) {
        super(fileIndex, file);
        this.qualityFormat = QualityFormat.fromName(fileIndex.getMetadata("format"));
        this.recordsReader = new FastqRecordsReader(lazyReads, file, 524288, replaceWildcards, false);
    }

    @Override
    public long getNumberOfReads() {
        return this.fileIndex.getLastRecordNumber() + 1L;
    }

    @Override
    public synchronized SingleRead take() {
        if (this.recordsReader.closed.get()) {
            return null;
        }
        return (SingleRead)super.take();
    }

    @Override
    public synchronized SingleRead take(long recordNumber) {
        if (this.recordsReader.closed.get()) {
            return null;
        }
        try {
            return (SingleRead)super.take(recordNumber);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected SingleRead take0() {
        try {
            if (!this.recordsReader.nextRecord(true)) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.recordsReader.createRead(this.currentRecordNumber, this.qualityFormat);
    }

    @Override
    protected void skip() {
        try {
            this.recordsReader.nextRecord(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void resetBufferOnSeek() {
        try {
            this.recordsReader.resetBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.recordsReader.close();
    }
}

