/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fastq;

import cc.redberry.pipe.OutputPortCloseable;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReader;
import com.milaboratory.core.io.sequence.fastq.SingleFastqReader;
import com.milaboratory.core.io.util.FileIndex;
import com.milaboratory.core.io.util.FileIndexBuilder;
import com.milaboratory.util.CanReportProgress;

public class SingleFastqIndexer
implements SingleReader,
CanReportProgress,
OutputPortCloseable<SingleRead> {
    private final SingleFastqReader reader;
    private final FileIndexBuilder indexBuilder;

    public SingleFastqIndexer(SingleFastqReader reader, long step) {
        this.reader = reader;
        this.indexBuilder = new FileIndexBuilder(step);
    }

    public SingleFastqReader setTotalSize(long totalSize) {
        return this.reader.setTotalSize(totalSize);
    }

    @Override
    public double getProgress() {
        return this.reader.getProgress();
    }

    @Override
    public boolean isFinished() {
        return this.reader.isFinished();
    }

    public SingleRead take() {
        SingleRead read = this.reader.take();
        if (read == null) {
            return null;
        }
        this.indexBuilder.appendNextRecord(this.reader.recordsReader.qualityEnd - this.reader.recordsReader.descriptionBegin + 2);
        return read;
    }

    @Override
    public long getNumberOfReads() {
        return this.reader.getNumberOfReads();
    }

    public void close() {
        this.reader.close();
    }

    public FileIndex createIndex() {
        this.indexBuilder.putMetadata("format", this.reader.getQualityFormat().toString());
        return this.indexBuilder.createAndDestroy();
    }

    public SingleFastqIndexer readToEnd() {
        while (this.take() != null) {
        }
        return this;
    }
}

