/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fastq;

import com.milaboratory.core.io.CompressionType;
import com.milaboratory.core.io.sequence.SequenceReaderCloseable;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleReader;
import com.milaboratory.core.io.sequence.fastq.FastqRecordsReader;
import com.milaboratory.core.io.sequence.fastq.QualityFormat;
import com.milaboratory.util.CanReportProgress;
import com.milaboratory.util.CountingInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class SingleFastqReader
implements SingleReader,
CanReportProgress,
SequenceReaderCloseable<SingleRead> {
    public static final int DEFAULT_BUFFER_SIZE = 524288;
    public static final QualityFormat DEFAULT_QUALITY_FORMAT = QualityFormat.Phred33;
    private long totalSize;
    private final QualityFormat format;
    private final CountingInputStream countingInputStream;
    long idCounter;
    final FastqRecordsReader recordsReader;

    public SingleFastqReader(String file, boolean replaceWildcards, boolean lazyReads) throws IOException {
        this(new FileInputStream(file), DEFAULT_QUALITY_FORMAT, CompressionType.detectCompressionType(file), true, 524288, replaceWildcards, lazyReads);
    }

    public SingleFastqReader(String file, boolean replaceWildcards) throws IOException {
        this(file, replaceWildcards, true);
    }

    public SingleFastqReader(String file) throws IOException {
        this(file, false);
    }

    public SingleFastqReader(String file, CompressionType ct) throws IOException {
        this(new FileInputStream(file), DEFAULT_QUALITY_FORMAT, ct, true, 524288, false, true);
    }

    public SingleFastqReader(String file, QualityFormat format, CompressionType ct) throws IOException {
        this(new FileInputStream(file), format, ct, format == null, 524288, false, true);
    }

    public SingleFastqReader(File file, boolean replaceWildcards, boolean lazyReads) throws IOException {
        this(new FileInputStream(file), DEFAULT_QUALITY_FORMAT, CompressionType.detectCompressionType(file), true, 524288, replaceWildcards, lazyReads);
    }

    public SingleFastqReader(File file, boolean replaceWildcards) throws IOException {
        this(file, replaceWildcards, true);
    }

    public SingleFastqReader(File file) throws IOException {
        this(file, false);
    }

    public SingleFastqReader(File file, CompressionType ct) throws IOException {
        this(new FileInputStream(file), DEFAULT_QUALITY_FORMAT, ct, true, 524288, false, true);
    }

    public SingleFastqReader(File file, QualityFormat format, CompressionType ct) throws IOException {
        this(new FileInputStream(file), format, ct, format == null, 524288, false, true);
    }

    public SingleFastqReader(InputStream stream, CompressionType ct) throws IOException {
        this(stream, DEFAULT_QUALITY_FORMAT, ct, true, 524288, false, true);
    }

    public SingleFastqReader(InputStream stream) throws IOException {
        this(stream, DEFAULT_QUALITY_FORMAT, CompressionType.None, true, 524288, false, true);
    }

    public SingleFastqReader(InputStream stream, boolean replaceWildcards) throws IOException {
        this(stream, DEFAULT_QUALITY_FORMAT, CompressionType.None, true, 524288, replaceWildcards, true);
    }

    public SingleFastqReader(InputStream stream, QualityFormat format, CompressionType ct) throws IOException {
        this(stream, format, ct, false, 524288, false, true);
    }

    public SingleFastqReader(InputStream stream, QualityFormat format, CompressionType ct, boolean guessQualityFormat, int bufferSize, boolean replaceWildcards, boolean lazyReads) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        this.totalSize = stream instanceof FileInputStream ? ((FileInputStream)stream).getChannel().size() : -1L;
        this.countingInputStream = new CountingInputStream(stream);
        stream = ct.createInputStream(this.countingInputStream, Math.max(bufferSize / 2, 2048));
        this.recordsReader = new FastqRecordsReader(lazyReads, stream, bufferSize, replaceWildcards, true);
        if (guessQualityFormat) {
            this.recordsReader.fillBuffer(524288);
            QualityFormat f = this.guessFormat();
            this.recordsReader.pointer = 0;
            if (f != null) {
                format = f;
            }
        }
        if (format == null) {
            if (guessQualityFormat) {
                throw new RuntimeException("Format guess failed.");
            }
            throw new NullPointerException();
        }
        this.format = format;
    }

    public SingleFastqReader setTotalSize(long totalSize) {
        this.totalSize = totalSize;
        return this;
    }

    public QualityFormat getQualityFormat() {
        assert (this.format != null);
        return this.format;
    }

    @Override
    public double getProgress() {
        return this.totalSize == -1L ? Double.NaN : 1.0 * (double)this.countingInputStream.getBytesRead() / (double)this.totalSize;
    }

    @Override
    public boolean isFinished() {
        return this.recordsReader.closed.get();
    }

    public synchronized SingleRead take() {
        if (this.recordsReader.closed.get()) {
            return null;
        }
        try {
            if (!this.recordsReader.nextRecord(true)) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.recordsReader.createRead(this.idCounter++, this.format);
    }

    @Override
    public synchronized long getNumberOfReads() {
        return this.idCounter;
    }

    public void close() {
        this.recordsReader.close();
    }

    private QualityFormat guessFormat() throws IOException {
        boolean signal33 = false;
        boolean signal64 = false;
        while (this.recordsReader.nextRecord(false)) {
            for (int k = this.recordsReader.qualityBegin; k < this.recordsReader.qualityEnd; ++k) {
                byte chr = this.recordsReader.buffer[k];
                signal33 |= chr - 64 < QualityFormat.Phred64.getMinValue();
                signal64 |= chr - 33 > QualityFormat.Phred33.getMaxValue();
            }
        }
        if (signal33 && signal64) {
            return null;
        }
        if (signal33) {
            return QualityFormat.Phred33;
        }
        if (signal64) {
            return QualityFormat.Phred64;
        }
        return null;
    }
}

