/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.sequence.fastq;

import com.milaboratory.core.io.CompressionType;
import com.milaboratory.core.io.sequence.SingleRead;
import com.milaboratory.core.io.sequence.SingleSequenceWriter;
import com.milaboratory.core.io.sequence.fastq.QualityFormat;
import com.milaboratory.core.sequence.NucleotideAlphabet;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.SequenceQuality;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class SingleFastqWriter
implements SingleSequenceWriter {
    public static final int DEFAULT_BUFFER_SIZE = 131072;
    final OutputStream outputStream;
    final QualityFormat qualityFormat;
    final byte[] buffer;
    int pointer;

    public SingleFastqWriter(String fileName) throws IOException {
        this(new FileOutputStream(fileName), QualityFormat.Phred33, CompressionType.detectCompressionType(fileName), 131072);
    }

    public SingleFastqWriter(File file) throws IOException {
        this(new FileOutputStream(file), QualityFormat.Phred33, CompressionType.detectCompressionType(file), 131072);
    }

    public SingleFastqWriter(OutputStream outputStream) throws IOException {
        this(outputStream, QualityFormat.Phred33, CompressionType.None, 131072);
    }

    public SingleFastqWriter(File file, QualityFormat qualityFormat, CompressionType ct) throws IOException {
        this(new FileOutputStream(file), qualityFormat, ct, 131072);
    }

    public SingleFastqWriter(String fileName, QualityFormat qualityFormat, CompressionType ct) throws IOException {
        this(new FileOutputStream(fileName), qualityFormat, ct, 131072);
    }

    public SingleFastqWriter(OutputStream outputStream, QualityFormat qualityFormat, CompressionType ct) throws IOException {
        this(outputStream, qualityFormat, ct, 131072);
    }

    public SingleFastqWriter(OutputStream outputStream, QualityFormat qualityFormat, CompressionType ct, int bufferSize) throws IOException {
        this.outputStream = ct.createOutputStream(outputStream, bufferSize / 2);
        this.qualityFormat = qualityFormat;
        this.buffer = new byte[bufferSize];
    }

    @Override
    public synchronized void write(SingleRead read) {
        String description = read.getDescription();
        int len = description.length();
        this.flushIfNeededToWrite(len + 1);
        this.buffer[this.pointer++] = 64;
        for (int i = 0; i < len; ++i) {
            this.buffer[this.pointer++] = (byte)description.charAt(i);
        }
        NucleotideSequence sequence = (NucleotideSequence)read.getData().getSequence();
        SequenceQuality quality = read.getData().getQuality();
        len = sequence.size();
        this.flushIfNeededToWrite(len + 2);
        this.buffer[this.pointer++] = 10;
        for (int i = 0; i < len; ++i) {
            this.buffer[this.pointer++] = NucleotideAlphabet.symbolByteFromCode(sequence.codeAt(i));
        }
        this.buffer[this.pointer++] = 10;
        this.flushIfNeededToWrite(len + 3);
        this.buffer[this.pointer++] = 43;
        this.buffer[this.pointer++] = 10;
        quality.encodeTo(this.qualityFormat, this.buffer, this.pointer);
        this.pointer += len;
        this.buffer[this.pointer++] = 10;
    }

    private void flushIfNeededToWrite(int sizeToWrite) {
        if (this.buffer.length - this.pointer < sizeToWrite) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        try {
            this.outputStream.write(this.buffer, 0, this.pointer);
            this.pointer = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

