/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.util;

import cc.redberry.pipe.OutputPort;
import com.milaboratory.core.io.util.FileIndex;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AbstractRandomAccessReader<T>
implements OutputPort<T> {
    protected final FileIndex fileIndex;
    protected final RandomAccessFile file;
    protected long currentRecordNumber;

    protected AbstractRandomAccessReader(FileIndex fileIndex, RandomAccessFile file) {
        this.fileIndex = fileIndex;
        this.file = file;
    }

    public long getCurrentRecordNumber() {
        return this.currentRecordNumber;
    }

    public void seekToRecord(long recordNumber) throws IOException {
        long skip;
        if (this.currentRecordNumber == recordNumber) {
            return;
        }
        if (recordNumber < this.fileIndex.getStartingRecordNumber()) {
            if (this.currentRecordNumber < recordNumber) {
                skip = recordNumber - this.currentRecordNumber;
            } else {
                skip = recordNumber;
                this.seek0(0L);
            }
        } else if (recordNumber > this.fileIndex.getLastRecordNumber()) {
            if (this.currentRecordNumber < recordNumber) {
                skip = recordNumber - this.currentRecordNumber;
            } else {
                long record = this.fileIndex.getLastRecordNumber();
                skip = recordNumber - record;
                this.seek0(this.fileIndex.getNearestPosition(record));
            }
        } else if (recordNumber > this.currentRecordNumber && recordNumber - this.currentRecordNumber < this.fileIndex.getStep()) {
            skip = recordNumber - this.currentRecordNumber;
        } else {
            this.seek0(this.fileIndex.getNearestPosition(recordNumber));
            skip = recordNumber - this.fileIndex.getNearestRecordNumber(recordNumber);
        }
        while (skip > 0L) {
            this.skip();
            --skip;
        }
        this.currentRecordNumber = recordNumber;
    }

    public T take(long recordNumber) throws IOException {
        this.seekToRecord(recordNumber);
        T t = this.take0();
        if (t != null) {
            ++this.currentRecordNumber;
        }
        return t;
    }

    public T take() {
        T t = this.take0();
        if (t != null) {
            ++this.currentRecordNumber;
        }
        return t;
    }

    private void seek0(long position) throws IOException {
        this.file.seek(position);
        this.resetBufferOnSeek();
    }

    protected void resetBufferOnSeek() {
    }

    protected void skip() {
        this.take0();
    }

    protected abstract T take0();
}

