/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.util;

import com.milaboratory.core.io.util.IOUtil;
import gnu.trove.list.array.TLongArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public final class FileIndex {
    public static final int MAGIC = -1659399333;
    final long step;
    final Map<String, String> metadata;
    final TLongArrayList index;
    final long startingRecordNumber;
    final long lastRecordNumber;

    FileIndex(long step, Map<String, String> metadata, TLongArrayList index, long startingRecordNumber, long lastRecordNumber) {
        this.step = step;
        this.metadata = metadata;
        this.index = index;
        this.startingRecordNumber = startingRecordNumber;
        this.lastRecordNumber = lastRecordNumber;
    }

    public long getStep() {
        return this.step;
    }

    public long getStartingRecordNumber() {
        return this.startingRecordNumber;
    }

    public long getLastRecordNumber() {
        return this.lastRecordNumber;
    }

    public String getMetadata(String key) {
        return this.metadata.get(key);
    }

    public long getNearestPosition(long recordNumber) {
        if (recordNumber < this.startingRecordNumber || recordNumber > this.lastRecordNumber) {
            throw new IndexOutOfBoundsException();
        }
        return this.index.get((int)((recordNumber - this.startingRecordNumber) / this.step));
    }

    public long getNearestRecordNumber(long recordNumber) {
        if (recordNumber < this.startingRecordNumber || recordNumber > this.lastRecordNumber) {
            throw new IndexOutOfBoundsException();
        }
        return this.startingRecordNumber + this.step * ((recordNumber - this.startingRecordNumber) / this.step);
    }

    public void write(String fileName) throws IOException {
        this.write(new File(fileName));
    }

    public void write(File file) throws IOException {
        this.write(new FileOutputStream(file));
    }

    public void write(OutputStream stream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DeflaterOutputStream deflate = new DeflaterOutputStream(bos);
        DataOutputStream dataStream = new DataOutputStream(deflate);
        dataStream.writeLong(this.step);
        dataStream.writeLong(this.getStartingRecordNumber());
        dataStream.writeLong(this.getLastRecordNumber());
        dataStream.writeInt(this.metadata.size());
        for (Map.Entry<String, String> e : this.metadata.entrySet()) {
            dataStream.writeUTF(e.getKey());
            dataStream.writeUTF(e.getValue());
        }
        dataStream.writeInt(this.index.size());
        long lastValue = 0L;
        for (int i = 0; i < this.index.size(); ++i) {
            long v = this.index.get(i);
            IOUtil.writeRawVarint64(dataStream, v - lastValue);
            lastValue = v;
        }
        deflate.finish();
        DataOutputStream raw = new DataOutputStream(stream);
        raw.writeInt(-1659399333);
        raw.writeInt(bos.size());
        raw.write(bos.toByteArray());
    }

    public static FileIndex read(String fileName) throws IOException {
        return FileIndex.read(new File(fileName));
    }

    public static FileIndex read(File file) throws IOException {
        return FileIndex.read(new FileInputStream(file));
    }

    public static FileIndex read(InputStream stream) throws IOException {
        DataInputStream raw = new DataInputStream(stream);
        int magic = raw.readInt();
        if (magic != -1659399333) {
            throw new IOException("Wrong magic number");
        }
        int length = raw.readInt();
        byte[] buffer = new byte[length];
        raw.read(buffer);
        InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(buffer));
        DataInputStream dataStream = new DataInputStream(inflater);
        long step = dataStream.readLong();
        long startingRecordNumner = dataStream.readLong();
        long lastRecordNumber = dataStream.readLong();
        int metaRecordsCount = dataStream.readInt();
        HashMap<String, String> metadata = new HashMap<String, String>();
        while (--metaRecordsCount >= 0) {
            String key = dataStream.readUTF();
            String value = dataStream.readUTF();
            metadata.put(key, value);
        }
        int size = dataStream.readInt();
        TLongArrayList index = new TLongArrayList(size);
        long last = 0L;
        for (int i = 0; i < size; ++i) {
            long val = IOUtil.readRawVarint64(dataStream, -1L);
            if (val == -1L) {
                throw new IOException("Wrong file format");
            }
            index.add(last += val);
        }
        return new FileIndex(step, metadata, index, startingRecordNumner, lastRecordNumber);
    }
}

