/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.util;

import com.milaboratory.core.io.util.FileIndex;
import gnu.trove.list.array.TLongArrayList;
import java.util.HashMap;
import java.util.Map;

public final class FileIndexBuilder {
    private final long step;
    private final Map<String, String> metadata = new HashMap<String, String>();
    private final TLongArrayList index = new TLongArrayList();
    private long currentByte = 0L;
    private long currentRecord = 0L;
    private long startingRecordNumber;
    private long startingByte;
    private boolean destroyed = false;

    public FileIndexBuilder(long step) {
        if (step == 0L) {
            throw new IllegalArgumentException("step must be > 0.");
        }
        this.step = step;
        this.startingByte = 0L;
        this.index.add(0L);
    }

    public FileIndexBuilder setStartingRecordPosition(long recordPosition) {
        this.checkIfDestroyed();
        if (this.index.size() != 1) {
            throw new IllegalStateException("Initial record is already initialised to " + this.index.get(0));
        }
        this.startingByte = recordPosition;
        this.index.set(0, this.startingByte);
        return this;
    }

    public FileIndexBuilder setStartingRecordNumber(long recordNumber) {
        this.checkIfDestroyed();
        if (this.index.size() != 1) {
            throw new IllegalStateException("Initial record is already initialised to " + this.index.get(0));
        }
        this.startingRecordNumber = recordNumber;
        return this;
    }

    public FileIndexBuilder putMetadata(String key, String value) {
        this.checkIfDestroyed();
        this.metadata.put(key, value);
        return this;
    }

    public FileIndexBuilder appendNextRecord(long recordSize) {
        this.checkIfDestroyed();
        if (recordSize < 0L) {
            throw new IllegalArgumentException("Size cannot be negative.");
        }
        if (this.currentRecord == this.step) {
            this.index.add(this.startingByte + this.currentByte);
            this.currentRecord = 0L;
        }
        this.currentByte += recordSize;
        ++this.currentRecord;
        return this;
    }

    public long lastAccessibleRecordNumber() {
        return this.startingRecordNumber + this.step * (long)(this.index.size() - 1);
    }

    public FileIndex createAndDestroy() {
        this.checkIfDestroyed();
        this.destroyed = true;
        return new FileIndex(this.step, this.metadata, this.index, this.startingRecordNumber, this.lastAccessibleRecordNumber());
    }

    private void checkIfDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("This builder is destryed.");
        }
    }
}

