/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.io.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static int readRawVarint32(InputStream is, int eofVaule) throws IOException {
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            int b = is.read();
            if (b == -1) {
                if (shift == 0) {
                    return eofVaule;
                }
                throw new IOException("Malformed Varint");
            }
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed Varint");
    }

    public static long readRawVarint64(InputStream is, long eofValue) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            int b = is.read();
            if (b == -1) {
                if (shift == 0) {
                    return eofValue;
                }
                throw new IOException("Malformed Varint");
            }
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed Varint");
    }

    public static void writeRawVarint32(OutputStream os, int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                os.write(value);
                return;
            }
            os.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static void writeRawVarint64(OutputStream os, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                os.write((int)value);
                return;
            }
            os.write((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }
}

