/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.merger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.milaboratory.core.PairedEndReadsLayout;
import com.milaboratory.core.merger.QualityMergingAlgorithm;
import com.milaboratory.primitivio.annotations.Serializable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
@Serializable(asJson=true)
public final class MergerParameters
implements java.io.Serializable {
    public static final int DEFAULT_MAX_QUALITY_VALUE = 50;
    final QualityMergingAlgorithm qualityMergingAlgorithm;
    final PairedEndReadsLayout partsLayout;
    final int minimalOverlap;
    final int maxQuality;
    final double minimalIdentity;
    final IdentityType identityType;

    @JsonCreator
    public MergerParameters(@JsonProperty(value="qualityMergingAlgorithm") QualityMergingAlgorithm qualityMergingAlgorithm, @JsonProperty(value="partsLayout") PairedEndReadsLayout partsLayout, @JsonProperty(value="minimalOverlap") int minimalOverlap, @JsonProperty(value="maxQuality") Integer maxQuality, @JsonProperty(value="minimalIdentity") double minimalIdentity, @JsonProperty(value="identityType") IdentityType identityType) {
        this.qualityMergingAlgorithm = qualityMergingAlgorithm;
        this.partsLayout = partsLayout;
        this.minimalOverlap = minimalOverlap;
        this.minimalIdentity = minimalIdentity;
        this.maxQuality = maxQuality == null ? 50 : maxQuality;
        this.identityType = identityType;
    }

    public int getMinimalOverlap() {
        return this.minimalOverlap;
    }

    public double getMinimalIdentity() {
        return this.minimalIdentity;
    }

    public int getMaxQuality() {
        return this.maxQuality;
    }

    public QualityMergingAlgorithm getQualityMergingAlgorithm() {
        return this.qualityMergingAlgorithm;
    }

    public PairedEndReadsLayout getPartsLayout() {
        return this.partsLayout;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public MergerParameters overrideReadsLayout(PairedEndReadsLayout partsLayout) {
        return new MergerParameters(this.qualityMergingAlgorithm, partsLayout, this.minimalOverlap, this.maxQuality, this.minimalIdentity, this.identityType);
    }

    public MergerParameters overrideMinimalIdentity(double newIdentity) {
        return new MergerParameters(this.qualityMergingAlgorithm, this.partsLayout, this.minimalOverlap, this.maxQuality, newIdentity, this.identityType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergerParameters that = (MergerParameters)o;
        if (this.minimalOverlap != that.minimalOverlap) {
            return false;
        }
        if (this.maxQuality != that.maxQuality) {
            return false;
        }
        if (Double.compare(that.minimalIdentity, this.minimalIdentity) != 0) {
            return false;
        }
        if (this.qualityMergingAlgorithm != that.qualityMergingAlgorithm) {
            return false;
        }
        if (this.partsLayout != that.partsLayout) {
            return false;
        }
        return this.identityType == that.identityType;
    }

    public int hashCode() {
        int result = this.qualityMergingAlgorithm != null ? this.qualityMergingAlgorithm.hashCode() : 0;
        result = 31 * result + (this.partsLayout != null ? this.partsLayout.hashCode() : 0);
        result = 31 * result + this.minimalOverlap;
        result = 31 * result + this.maxQuality;
        long temp = Double.doubleToLongBits(this.minimalIdentity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.identityType != null ? this.identityType.hashCode() : 0);
        return result;
    }

    public static enum IdentityType {
        Unweighted,
        MinimalQualityWeighted;

    }
}

