/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.merger;

import cc.redberry.pipe.Processor;
import com.milaboratory.core.PairedEndReadsLayout;
import com.milaboratory.core.io.sequence.PairedRead;
import com.milaboratory.core.merger.MergerParameters;
import com.milaboratory.core.merger.PairedReadMergingResult;
import com.milaboratory.core.merger.QualityMergingAlgorithm;
import com.milaboratory.core.motif.BitapMatcher;
import com.milaboratory.core.motif.BitapPattern;
import com.milaboratory.core.motif.Motif;
import com.milaboratory.core.motif.MotifUtils;
import com.milaboratory.core.sequence.NSequenceWithQuality;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.core.sequence.SequenceQualityBuilder;
import com.milaboratory.core.sequence.SequencesUtils;
import java.io.Serializable;

public final class MismatchOnlyPairedReadMerger
implements Processor<PairedRead, PairedReadMergingResult>,
Serializable {
    public static final int MIN_SCORE_VALUE = 0;
    final int minOverlap;
    final double minimalIdentity;
    final MergerParameters.IdentityType identityType;
    final double maxMismatchesPart;
    final int maxScoreValue;
    final boolean[] strands;
    final int motifLength;
    final int maxMismatchesInMotif;
    final QualityMergingAlgorithm qualityMergingAlgorithm;
    final PairedEndReadsLayout pairedEndReadsLayout;

    public MismatchOnlyPairedReadMerger(MergerParameters parameters) {
        this(parameters.getMinimalOverlap(), parameters.getMinimalIdentity(), parameters.getIdentityType(), parameters.getMaxQuality(), parameters.qualityMergingAlgorithm, parameters.getPartsLayout());
    }

    public MismatchOnlyPairedReadMerger(int minOverlap, double minimalIdentity, int maxScoreValue, QualityMergingAlgorithm qualityMergingAlgorithm, PairedEndReadsLayout pairedEndReadsLayout) {
        this(minOverlap, minimalIdentity, MergerParameters.IdentityType.Unweighted, maxScoreValue, qualityMergingAlgorithm, pairedEndReadsLayout);
    }

    public MismatchOnlyPairedReadMerger(int minOverlap, double minimalIdentity, MergerParameters.IdentityType identityType, int maxScoreValue, QualityMergingAlgorithm qualityMergingAlgorithm, PairedEndReadsLayout pairedEndReadsLayout) {
        if (qualityMergingAlgorithm == null || pairedEndReadsLayout == null) {
            throw new NullPointerException();
        }
        this.qualityMergingAlgorithm = qualityMergingAlgorithm;
        this.pairedEndReadsLayout = pairedEndReadsLayout;
        this.minOverlap = minOverlap;
        this.minimalIdentity = minimalIdentity;
        this.identityType = identityType;
        this.maxMismatchesPart = 1.0 - minimalIdentity;
        this.strands = pairedEndReadsLayout.getPossibleRelativeStrands();
        this.maxScoreValue = maxScoreValue;
        this.motifLength = Math.min(minOverlap, 62);
        this.maxMismatchesInMotif = (int)Math.round((double)this.motifLength * this.maxMismatchesPart);
    }

    public PairedReadMergingResult merge(NSequenceWithQuality read1p, NSequenceWithQuality read2p) {
        return this.merge(read1p, read2p, null);
    }

    public PairedReadMergingResult merge(NSequenceWithQuality read1p, NSequenceWithQuality read2p, PairedRead pairedRead) {
        if (read1p.size() < this.minOverlap || read2p.size() < this.minOverlap) {
            return new PairedReadMergingResult(pairedRead);
        }
        PairedReadMergingResult ret = null;
        for (boolean strand : this.strands) {
            int matchPosition;
            NSequenceWithQuality read1 = read1p;
            NSequenceWithQuality read2 = strand ? read2p.getReverseComplement() : read2p;
            boolean swapped = false;
            if (read2.size() > read1.size()) {
                NSequenceWithQuality tmp = read1;
                read1 = read2;
                read2 = tmp;
                swapped = true;
            }
            Motif motif = MotifUtils.twoSequenceMotif(read2.getSequence(), 0, read2.getSequence(), read2.size() - this.motifLength, this.motifLength);
            BitapPattern bitapPattern = motif.getBitapPattern();
            BitapMatcher bitapMatcher = bitapPattern.substitutionOnlyMatcherFirst(this.maxMismatchesInMotif, (Sequence)read1.getSequence());
            PairedReadMergingResult tmp = null;
            while ((matchPosition = bitapMatcher.findNext()) != -1) {
                int overlap = Math.min(read1.size() - matchPosition, read2.size());
                int mismatches = SequencesUtils.mismatchCount(read1.getSequence(), matchPosition, read2.getSequence(), 0, overlap);
                double identity = MismatchOnlyPairedReadMerger.identity(this.identityType, read1, matchPosition, read2, 0, overlap);
                if (identity >= this.minimalIdentity) {
                    tmp = new PairedReadMergingResult(pairedRead, this.overlap(read1, read2, matchPosition), overlap, mismatches, strand, swapped ? -matchPosition : matchPosition, this.identityType, identity);
                    break;
                }
                overlap = Math.min(matchPosition += this.motifLength, read2.size());
                mismatches = SequencesUtils.mismatchCount(read1.getSequence(), matchPosition - overlap, read2.getSequence(), Math.max(0, read2.size() - overlap), overlap);
                identity = MismatchOnlyPairedReadMerger.identity(this.identityType, read1, matchPosition - overlap, read2, Math.max(0, read2.size() - overlap), overlap);
                if (!(identity >= this.minimalIdentity)) continue;
                int offset = Math.min(matchPosition - read2.size(), 0);
                tmp = new PairedReadMergingResult(pairedRead, this.overlap(read1, read2, offset), overlap, mismatches, strand, swapped ? -offset : offset, this.identityType, identity);
                break;
            }
            if (tmp == null || ret != null && ret.score() >= tmp.score()) continue;
            ret = tmp;
        }
        if (ret == null) {
            return new PairedReadMergingResult(pairedRead);
        }
        return ret;
    }

    public static double identity(MergerParameters.IdentityType identityType, NSequenceWithQuality seq1, int offset1, NSequenceWithQuality seq2, int offset2, int length) {
        if (length == 0) {
            return 0.0;
        }
        NucleotideSequence seq1s = (NucleotideSequence)seq1.getSequence();
        NucleotideSequence seq2s = (NucleotideSequence)seq2.getSequence();
        switch (identityType) {
            case Unweighted: {
                return 1.0 * (double)(length - SequencesUtils.mismatchCount(seq1s, offset1, seq2s, offset2, length)) / (double)length;
            }
            case MinimalQualityWeighted: {
                if (seq1.size() < offset1 + length || seq2.size() < offset2 + length) {
                    throw new IllegalArgumentException();
                }
                long identQuality = 0L;
                long totalQuality = 0L;
                int nIdentical = 0;
                for (int i = 0; i < length; ++i) {
                    int minQuality = Math.min(seq1.getQuality().value(i + offset1), seq2.getQuality().value(i + offset2));
                    if (seq1s.codeAt(i + offset1) == seq2s.codeAt(i + offset2)) {
                        identQuality += (long)minQuality;
                        ++nIdentical;
                    }
                    totalQuality += (long)minQuality;
                }
                if (totalQuality == 0L) {
                    return 1.0 * (double)nIdentical / (double)length;
                }
                return 1.0 * (double)identQuality / (double)totalQuality;
            }
        }
        throw new RuntimeException("not supported identity type: " + (Object)((Object)identityType));
    }

    public PairedReadMergingResult process(PairedRead pairedRead) {
        NSequenceWithQuality read1p = pairedRead.getR1().getData();
        NSequenceWithQuality read2p = pairedRead.getR2().getData();
        return this.merge(read1p, read2p, pairedRead);
    }

    public NSequenceWithQuality overlap(NSequenceWithQuality seq1, NSequenceWithQuality seq2, int offset) {
        if (this.qualityMergingAlgorithm == null) {
            throw new NullPointerException();
        }
        int length = Math.abs(offset) + (offset >= 0 ? Math.max(seq1.size() - offset, seq2.size()) : Math.max(seq1.size(), seq2.size() + offset));
        SequenceBuilder<byte> seqBuilder = NucleotideSequence.ALPHABET.createBuilder().ensureCapacity(length);
        SequenceQualityBuilder qualBuilder = (SequenceQualityBuilder)new SequenceQualityBuilder().ensureCapacity(length);
        int from = Math.min(0, offset);
        int to = length + from;
        for (int i = from; i < to; ++i) {
            int position;
            byte quality = 0;
            byte letter = -1;
            if (i >= 0 && i < seq1.size()) {
                quality = seq1.getQuality().value(i);
                letter = ((NucleotideSequence)seq1.getSequence()).codeAt(i);
            }
            if ((position = i - offset) >= 0 && position < seq2.size()) {
                byte l = ((NucleotideSequence)seq2.getSequence()).codeAt(position);
                byte q = seq2.getQuality().value(position);
                if (letter == -1) {
                    letter = l;
                    quality = q;
                } else if (letter == l) {
                    switch (this.qualityMergingAlgorithm) {
                        case SumSubtraction: 
                        case SumMax: {
                            quality = (byte)Math.min(this.maxScoreValue, quality + q);
                        }
                        case MaxSubtraction: 
                        case MaxMax: {
                            quality = (byte)Math.max(quality, q);
                        }
                    }
                } else {
                    switch (this.qualityMergingAlgorithm) {
                        case SumSubtraction: 
                        case MaxSubtraction: {
                            if (q > quality) {
                                letter = l;
                                quality = (byte)Math.max(0, q - quality);
                                break;
                            }
                            quality = (byte)Math.max(0, quality - q);
                            break;
                        }
                        case SumMax: 
                        case MaxMax: {
                            if (q <= quality) break;
                            letter = l;
                            quality = q;
                        }
                    }
                }
            }
            assert (letter != -1);
            seqBuilder.append(letter);
            qualBuilder.append(quality);
        }
        return new NSequenceWithQuality((NucleotideSequence)seqBuilder.createAndDestroy(), (SequenceQuality)qualBuilder.createAndDestroy());
    }
}

