/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.merger;

import com.milaboratory.core.io.sequence.PairedRead;
import com.milaboratory.core.merger.MergerParameters;
import com.milaboratory.core.sequence.NSequenceWithQuality;
import java.io.Serializable;

public class PairedReadMergingResult
implements Serializable {
    public static final int MATCH_SCORE = 2;
    public static final int MISMATCH_SCORE = -5;
    final PairedRead originalRead;
    final NSequenceWithQuality overlappedSequence;
    final int overlap;
    final int errors;
    final boolean reversed;
    final int offset;
    final MergerParameters.IdentityType identityType;
    final double identity;

    public PairedReadMergingResult(PairedRead originalRead) {
        this.originalRead = originalRead;
        this.overlappedSequence = null;
        this.overlap = 0;
        this.errors = -1;
        this.reversed = false;
        this.offset = Integer.MAX_VALUE;
        this.identityType = MergerParameters.IdentityType.Unweighted;
        this.identity = 0.0;
    }

    public PairedReadMergingResult(PairedRead originalRead, NSequenceWithQuality overlappedSequence, int overlap, int errors, boolean reversed, int offset, MergerParameters.IdentityType identityType, double identity) {
        this.originalRead = originalRead;
        this.overlappedSequence = overlappedSequence;
        this.overlap = overlap;
        this.errors = errors;
        this.reversed = reversed;
        this.offset = offset;
        this.identityType = identityType;
        this.identity = identity;
    }

    public boolean isSuccessful() {
        return this.overlappedSequence != null;
    }

    public PairedRead getOriginalRead() {
        return this.originalRead;
    }

    public NSequenceWithQuality getOverlappedSequence() {
        return this.overlappedSequence;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getErrors() {
        return this.errors;
    }

    public double getIdentity() {
        return this.identity;
    }

    public MergerParameters.IdentityType getIdentityType() {
        return this.identityType;
    }

    public int score() {
        return (this.overlap - this.errors) * 2 + this.errors * -5;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PairedReadMergingResult that = (PairedReadMergingResult)o;
        if (this.overlap != that.overlap) {
            return false;
        }
        if (this.errors != that.errors) {
            return false;
        }
        if (!this.originalRead.equals(that.originalRead)) {
            return false;
        }
        return this.overlappedSequence.equals(that.overlappedSequence);
    }

    public int hashCode() {
        int result = this.originalRead.hashCode();
        result = 31 * result + this.overlappedSequence.hashCode();
        result = 31 * result + this.overlap;
        result = 31 * result + this.errors;
        return result;
    }

    public String toString() {
        return "PairedReadMergingResult{originalRead=" + this.originalRead + ", overlappedSequence=" + this.overlappedSequence + ", overlap=" + this.overlap + ", errors=" + this.errors + '}';
    }
}

