/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.motif;

import com.milaboratory.core.motif.BitapMatcher;
import java.io.Serializable;
import java.util.Arrays;

public final class BitapMatcherFilter
implements BitapMatcher,
Serializable {
    final BitapMatcher nestedMatcher;
    final int[] positionsBuffer;
    final int[] errorsBuffer;

    public BitapMatcherFilter(BitapMatcher nestedMatcher) {
        this.nestedMatcher = nestedMatcher;
        this.positionsBuffer = new int[3];
        Arrays.fill(this.positionsBuffer, -1);
        this.errorsBuffer = new int[3];
        Arrays.fill(this.errorsBuffer, -1);
        this.next();
    }

    private void next() {
        System.arraycopy(this.positionsBuffer, 1, this.positionsBuffer, 0, 2);
        System.arraycopy(this.errorsBuffer, 1, this.errorsBuffer, 0, 2);
        int pos = this.nestedMatcher.findNext();
        if (pos == -1) {
            this.positionsBuffer[2] = -1;
            this.errorsBuffer[2] = -1;
        } else {
            this.positionsBuffer[2] = pos;
            this.errorsBuffer[2] = this.nestedMatcher.getNumberOfErrors();
        }
    }

    @Override
    public int findNext() {
        do {
            this.next();
        } while (this.positionsBuffer[0] != -1 && Math.abs(this.positionsBuffer[0] - this.positionsBuffer[1]) == 1 && this.errorsBuffer[0] + 1 == this.errorsBuffer[1] || this.positionsBuffer[2] != -1 && Math.abs(this.positionsBuffer[1] - this.positionsBuffer[2]) == 1 && this.errorsBuffer[1] == this.errorsBuffer[2] + 1);
        return this.positionsBuffer[1];
    }

    @Override
    public int getNumberOfErrors() {
        return this.errorsBuffer[1];
    }
}

