/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.motif;

import com.milaboratory.core.motif.BitapMatcher;
import com.milaboratory.core.motif.BitapMatcherImpl;
import com.milaboratory.core.sequence.Sequence;
import java.io.Serializable;

public final class BitapPattern
implements Serializable {
    final int size;
    final long[] patternMask;
    final long[] reversePatternMask;

    BitapPattern(int size, long[] patternMask, long[] reversePatternMask) {
        this.size = size;
        this.patternMask = patternMask;
        this.reversePatternMask = reversePatternMask;
    }

    public int exactSearch(Sequence sequence) {
        return this.exactSearch(sequence, 0, sequence.size());
    }

    public int exactSearch(Sequence sequence, int from) {
        return this.exactSearch(sequence, from, sequence.size());
    }

    public int exactSearch(Sequence sequence, int from, int to) {
        if (sequence.getAlphabet().size() != this.patternMask.length) {
            throw new IllegalArgumentException();
        }
        long R = -2L;
        long matchingMask = 1L << this.size;
        for (int i = from; i < to; ++i) {
            R |= this.patternMask[sequence.codeAt(i)];
            if (0L != ((R <<= 1) & matchingMask)) continue;
            return i - this.size + 1;
        }
        return -1;
    }

    public BitapMatcher exactMatcher(final Sequence sequence, final int from, final int to) {
        if (sequence.getAlphabet().size() != this.patternMask.length) {
            throw new IllegalArgumentException();
        }
        return new BitapMatcher(){
            long R = -2L;
            int current = from;

            @Override
            public int findNext() {
                long matchingMask = 1L << BitapPattern.this.size;
                for (int i = this.current; i < to; ++i) {
                    this.R |= BitapPattern.this.patternMask[sequence.codeAt(i)];
                    this.R <<= 1;
                    if (0L != (this.R & matchingMask)) continue;
                    this.current = i + 1;
                    return i - BitapPattern.this.size + 1;
                }
                this.current = to;
                return -1;
            }

            @Override
            public int getNumberOfErrors() {
                return 0;
            }
        };
    }

    public BitapMatcher substitutionOnlyMatcherFirst(int substitutions, Sequence sequence) {
        return this.substitutionOnlyMatcherFirst(substitutions, sequence, 0, sequence.size());
    }

    public BitapMatcher substitutionOnlyMatcherFirst(int substitutions, final Sequence sequence, int from, int to) {
        if (sequence.getAlphabet().size() != this.patternMask.length) {
            throw new IllegalArgumentException();
        }
        return new BitapMatcherImpl(substitutions + 1, from, to){

            @Override
            public int findNext() {
                long matchingMask = 1L << BitapPattern.this.size - 1;
                boolean match = false;
                for (int i = this.current; i < this.to; ++i) {
                    long currentPatternMask = BitapPattern.this.patternMask[sequence.codeAt(i)];
                    this.R[0] = this.R[0] << 1;
                    long mismatchTmp = this.R[0];
                    this.R[0] = this.R[0] | currentPatternMask;
                    if (0L == (this.R[0] & matchingMask)) {
                        this.errors = 0;
                        match = true;
                    }
                    for (int d = 1; d < this.R.length; ++d) {
                        int n = d;
                        this.R[n] = this.R[n] << 1;
                        long preMismatchTmp = this.R[d];
                        int n2 = d;
                        this.R[n2] = this.R[n2] | currentPatternMask;
                        int n3 = d;
                        this.R[n3] = this.R[n3] & mismatchTmp;
                        if (!match && 0L == (this.R[d] & matchingMask) && i >= BitapPattern.this.size - 1) {
                            this.errors = d;
                            match = true;
                        }
                        mismatchTmp = preMismatchTmp;
                    }
                    if (!match) continue;
                    this.current = i + 1;
                    return i - BitapPattern.this.size + 1;
                }
                this.current = this.to;
                return -1;
            }
        };
    }

    public BitapMatcher substitutionAndIndelMatcherLast(int maxNumberOfErrors, Sequence sequence) {
        return this.substitutionAndIndelMatcherLast(maxNumberOfErrors, sequence, 0, sequence.size());
    }

    public BitapMatcher substitutionAndIndelMatcherLast(int maxNumberOfErrors, final Sequence sequence, int from, int to) {
        if (sequence.getAlphabet().size() != this.patternMask.length) {
            throw new IllegalArgumentException();
        }
        return new BitapMatcherImpl(maxNumberOfErrors + 1, from, to){

            @Override
            public int findNext() {
                long matchingMask = 1L << BitapPattern.this.size - 1;
                boolean match = false;
                for (int i = this.current; i < this.to; ++i) {
                    long currentPatternMask = BitapPattern.this.patternMask[sequence.codeAt(i)];
                    long insertionTmp = this.R[0];
                    this.R[0] = this.R[0] << 1;
                    long mismatchTmp = this.R[0];
                    this.R[0] = this.R[0] | currentPatternMask;
                    long deletionTmp = this.R[0];
                    if (0L == (this.R[0] & matchingMask)) {
                        this.errors = 0;
                        match = true;
                    }
                    for (int d = 1; d < this.R.length; ++d) {
                        long preInsertionTmp = this.R[d];
                        int n = d;
                        this.R[n] = this.R[n] << 1;
                        long preMismatchTmp = this.R[d];
                        int n2 = d;
                        this.R[n2] = this.R[n2] | currentPatternMask;
                        int n3 = d;
                        this.R[n3] = this.R[n3] & (insertionTmp & mismatchTmp & deletionTmp << 1);
                        if (!match && 0L == (this.R[d] & matchingMask)) {
                            this.errors = d;
                            match = true;
                        }
                        deletionTmp = this.R[d];
                        insertionTmp = preInsertionTmp;
                        mismatchTmp = preMismatchTmp;
                    }
                    if (!match) continue;
                    this.current = i + 1;
                    return i;
                }
                this.current = this.to;
                return -1;
            }
        };
    }

    public BitapMatcher substitutionAndIndelMatcherFirst(int maxNumberOfErrors, Sequence sequence) {
        return this.substitutionAndIndelMatcherFirst(maxNumberOfErrors, sequence, 0, sequence.size());
    }

    public BitapMatcher substitutionAndIndelMatcherFirst(int maxNumberOfErrors, final Sequence sequence, int from, int to) {
        if (sequence.getAlphabet().size() != this.patternMask.length) {
            throw new IllegalArgumentException();
        }
        return new BitapMatcherImpl(maxNumberOfErrors + 1, to - 1, from){

            @Override
            public int findNext() {
                long matchingMask = 1L << BitapPattern.this.size - 1;
                boolean match = false;
                for (int i = this.current; i >= this.to; --i) {
                    long currentPatternMask = BitapPattern.this.reversePatternMask[sequence.codeAt(i)];
                    long insertionTmp = this.R[0];
                    this.R[0] = this.R[0] << 1;
                    long mismatchTmp = this.R[0];
                    this.R[0] = this.R[0] | currentPatternMask;
                    long deletionTmp = this.R[0];
                    if (0L == (this.R[0] & matchingMask)) {
                        this.errors = 0;
                        match = true;
                    }
                    for (int d = 1; d < this.R.length; ++d) {
                        long preInsertionTmp = this.R[d];
                        int n = d;
                        this.R[n] = this.R[n] << 1;
                        long preMismatchTmp = this.R[d];
                        int n2 = d;
                        this.R[n2] = this.R[n2] | currentPatternMask;
                        int n3 = d;
                        this.R[n3] = this.R[n3] & (insertionTmp & mismatchTmp & deletionTmp << 1);
                        if (!match && 0L == (this.R[d] & matchingMask)) {
                            this.errors = d;
                            match = true;
                        }
                        deletionTmp = this.R[d];
                        insertionTmp = preInsertionTmp;
                        mismatchTmp = preMismatchTmp;
                    }
                    if (!match) continue;
                    this.current = i - 1;
                    return i;
                }
                this.current = this.to - 1;
                return -1;
            }
        };
    }
}

