/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.motif;

import com.milaboratory.core.motif.BitapPattern;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.Wildcard;
import com.milaboratory.util.BitArray;
import java.io.Serializable;
import java.util.Arrays;

public final class Motif<S extends Sequence<S>>
implements Serializable {
    private final Alphabet<S> alphabet;
    private final int size;
    final BitArray data;
    final BitapPattern bitapPattern;

    Motif(Alphabet<S> alphabet, int size, BitArray data) {
        if (!Motif.dataConsistent(data, size)) {
            throw new IllegalArgumentException("Inconsistent data. Some positions in motif has no possible values.");
        }
        this.alphabet = alphabet;
        this.size = size;
        this.data = data;
        this.bitapPattern = this.toBitapPattern();
    }

    public Motif(S sequence) {
        this.alphabet = ((Sequence)sequence).getAlphabet();
        this.size = sequence.size();
        int alphabetSize = this.alphabet.size();
        this.data = new BitArray(alphabetSize * this.size);
        for (int i = 0; i < this.size; ++i) {
            Wildcard wildcard = this.alphabet.codeToWildcard(((Sequence)sequence).codeAt(i));
            for (int j = 0; j < wildcard.size(); ++j) {
                this.data.set(wildcard.getMatchingCode(j) * this.size + i);
            }
        }
        this.bitapPattern = this.toBitapPattern();
    }

    public Motif<S> or(Motif<S> other) {
        if (other.size != this.size) {
            throw new IllegalArgumentException("Supports only motifs with the same size as this.");
        }
        BitArray result = this.data.clone();
        result.or(other.data);
        return new Motif<S>(this.alphabet, this.size, result);
    }

    public BitapPattern getBitapPattern() {
        if (this.size >= 64) {
            throw new RuntimeException("Supports motifs with length less then 64.");
        }
        return this.bitapPattern;
    }

    private BitapPattern toBitapPattern() {
        if (this.size >= 64) {
            return null;
        }
        int aSize = this.alphabet.size();
        long[] patternMask = new long[aSize];
        long[] reversePatternMask = new long[aSize];
        Arrays.fill(patternMask, -1L);
        Arrays.fill(reversePatternMask, -1L);
        int p = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (!this.data.get(p++)) continue;
                int n = i;
                patternMask[n] = patternMask[n] & (1L << j ^ 0xFFFFFFFFFFFFFFFFL);
                int n2 = i;
                reversePatternMask[n2] = reversePatternMask[n2] & (1L << this.size - j - 1 ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        return new BitapPattern(this.size, patternMask, reversePatternMask);
    }

    public int size() {
        return this.size;
    }

    public boolean allows(byte code, int position) {
        return this.data.get(code * this.size + position);
    }

    public boolean matches(S sequence, int from) {
        if (from < 0 || from + this.size > sequence.size()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.allows(((Sequence)sequence).codeAt(from++), i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Motif motif = (Motif)o;
        if (this.size != motif.size) {
            return false;
        }
        if (!this.alphabet.equals(motif.alphabet)) {
            return false;
        }
        return this.data.equals(motif.data);
    }

    public int hashCode() {
        int result = this.alphabet.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + this.data.hashCode();
        return result;
    }

    private static final boolean dataConsistent(BitArray data, int size) {
        block0: for (int i = 0; i < size; ++i) {
            for (int j = i; j < data.size(); j += size) {
                if (data.get(j)) continue block0;
            }
            return false;
        }
        return true;
    }
}

