/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.motif;

import com.milaboratory.core.motif.Motif;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.Wildcard;
import com.milaboratory.util.BitArray;

public final class MotifBuilder<S extends Sequence<S>> {
    private final Alphabet<S> alphabet;
    private final int size;
    BitArray data;

    public MotifBuilder(Alphabet<S> alphabet, int size) {
        this.alphabet = alphabet;
        this.size = size;
        this.data = new BitArray(alphabet.size() * size);
    }

    public void setAllowedLetter(int position, byte letter) {
        if (letter > this.alphabet.basicSize()) {
            throw new IllegalArgumentException();
        }
        Wildcard wc = this.alphabet.codeToWildcard(letter);
        for (int i = 0; i < wc.size(); ++i) {
            this.data.set(wc.getMatchingCode(i) * this.size + position);
        }
    }

    public Motif<S> createAndDestroy() {
        BitArray d = this.data;
        this.data = null;
        return new Motif<S>(this.alphabet, this.size, d);
    }
}

