/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations;

import com.milaboratory.core.Range;

public final class CoverageCounter {
    final int refFrom;
    final int refTo;
    final long[] counters;

    public CoverageCounter(Range seqRange) {
        this(seqRange.getFrom(), seqRange.getTo());
    }

    public CoverageCounter(int refFrom, int refTo) {
        this.refFrom = refFrom;
        this.refTo = refTo;
        this.counters = new long[refTo - refFrom];
    }

    public void aggregate(Range r, Provider provider) {
        int from = r.getFrom();
        int to = r.getTo();
        if (from < this.refFrom || to > this.refTo) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = from; i < to; ++i) {
            int n = i;
            this.counters[n] = this.counters[n] + provider.delta(i);
        }
    }

    public void aggregate(Range r, int delta) {
        this.aggregate(r, CoverageCounter.constantDelta(delta));
    }

    public long count(int position) {
        return this.counters[position];
    }

    public static Provider constantDelta(final int delta) {
        return new Provider(){

            @Override
            public long delta(int position) {
                return delta;
            }
        };
    }

    public static interface Provider {
        public long delta(int var1);
    }
}

