/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations;

import com.milaboratory.core.mutations.MutationType;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.util.IntArrayList;

public final class Mutation {
    public static final int RAW_MUTATION_TYPE_SUBSTITUTION = 32;
    public static final int RAW_MUTATION_TYPE_DELETION = 64;
    public static final int RAW_MUTATION_TYPE_INSERTION = 96;
    public static final int RAW_MUTATION_TYPE_RESERVED = 0;
    public static final int MUTATION_TYPE_MASK = 96;
    public static final int MUTATION_POSITION_MASK = -4096;
    public static final int LETTER_MASK = 31;
    public static final int FROM_OFFSET = 7;
    public static final int POSITION_OFFSET = 12;
    public static final int MAX_POSITION_VALUE = 1048575;
    public static final int NON_MUTATION = 0;
    public static final int NON_MUTATION_1 = 1;
    public static final int MUTATION_TYPE_OFFSET = 5;
    public static IntArrayList.IntComparator POSITION_COMPARATOR = new IntArrayList.IntComparator(){

        @Override
        public int compare(int a, int b) {
            return Integer.compare((0x60 ^ a) & 0xFFFFF060, (0x60 ^ b) & 0xFFFFF060);
        }
    };

    private Mutation() {
    }

    public static int createInsertion(int position, int to) {
        return Mutation.createMutation(96, position, 0, to);
    }

    public static int createDeletion(int position, int from) {
        return Mutation.createMutation(64, position, from, 0);
    }

    public static int createSubstitution(int position, int from, int to) {
        return Mutation.createMutation(32, position, from, to);
    }

    public static int createMutation(MutationType type, int from, int to) {
        return Mutation.createMutation(type, 0, from, to);
    }

    public static int createMutation(int rawType, int from, int to) {
        return Mutation.createMutation(rawType, 0, from, to);
    }

    public static int createMutation(MutationType type, int position, int from, int to) {
        if (type == null) {
            throw new NullPointerException();
        }
        return Mutation.createMutation(type.rawType, position, from, to);
    }

    public static int createMutation(int rawType, int position, int from, int to) {
        if (position < 0 || position > 1048575) {
            throw new IllegalArgumentException();
        }
        return position << 12 | from << 7 | rawType | to;
    }

    public static int getPosition(int code) {
        return code >>> 12;
    }

    public static byte getFrom(int code) {
        return (byte)(code >> 7 & 0x1F);
    }

    public static char getFromSymbol(int code, Alphabet alphabet) {
        return alphabet.codeToSymbol((byte)(code >> 7 & 0x1F));
    }

    public static byte getTo(int code) {
        return (byte)(code & 0x1F);
    }

    public static char getToSymbol(int code, Alphabet alphabet) {
        return alphabet.codeToSymbol((byte)(code & 0x1F));
    }

    public static int getRawTypeCode(int code) {
        return code & 0x60;
    }

    public static MutationType getType(int code) {
        switch (code & 0x60) {
            case 32: {
                return MutationType.Substitution;
            }
            case 64: {
                return MutationType.Deletion;
            }
            case 96: {
                return MutationType.Insertion;
            }
        }
        return null;
    }

    public static boolean isSubstitution(int code) {
        return (code & 0x60) == 32;
    }

    public static boolean isInsertion(int code) {
        return (code & 0x60) == 96;
    }

    public static boolean isDeletion(int code) {
        return (code & 0x60) == 64;
    }

    public static boolean isInDel(int code) {
        int m = code & 0x60;
        return m == 64 || m == 96;
    }

    public static int move(int mutation, int offset) {
        return mutation + (offset << 12);
    }

    public static String toString(Alphabet alphabet, int mutation) {
        switch (mutation & 0x60) {
            case 32: {
                return "S" + (mutation >>> 12) + ":" + alphabet.codeToSymbol((byte)(mutation >> 7 & 0x1F)) + "->" + alphabet.codeToSymbol((byte)(mutation & 0x1F));
            }
            case 64: {
                return "D" + (mutation >>> 12) + ":" + alphabet.codeToSymbol((byte)(mutation >> 7 & 0x1F));
            }
            case 96: {
                return "I" + (mutation >>> 12) + ":" + alphabet.codeToSymbol((byte)(mutation & 0x1F));
            }
        }
        return null;
    }

    public static String encode(int mutation, Alphabet alphabet) {
        switch (mutation & 0x60) {
            case 32: {
                return "S" + alphabet.codeToSymbol(Mutation.getFrom(mutation)) + Integer.toString(Mutation.getPosition(mutation)) + alphabet.codeToSymbol(Mutation.getTo(mutation));
            }
            case 64: {
                return "D" + alphabet.codeToSymbol(Mutation.getFrom(mutation)) + Integer.toString(Mutation.getPosition(mutation));
            }
            case 96: {
                return "I" + Integer.toString(Mutation.getPosition(mutation)) + alphabet.codeToSymbol(Mutation.getTo(mutation));
            }
        }
        throw new IllegalArgumentException("Illegal mutation code.");
    }

    public static String encodeFixed(int mutation, Alphabet alphabet) {
        switch (mutation & 0x60) {
            case 32: {
                return "S" + alphabet.codeToSymbol(Mutation.getFrom(mutation)) + Integer.toString(Mutation.getPosition(mutation)) + alphabet.codeToSymbol(Mutation.getTo(mutation));
            }
            case 64: {
                return "D" + alphabet.codeToSymbol(Mutation.getFrom(mutation)) + Integer.toString(Mutation.getPosition(mutation)) + ".";
            }
            case 96: {
                return "I." + Integer.toString(Mutation.getPosition(mutation)) + alphabet.codeToSymbol(Mutation.getTo(mutation));
            }
        }
        throw new IllegalArgumentException("Illegal mutation code.");
    }
}

