/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.Alignment;
import com.milaboratory.core.mutations.CoverageCounter;
import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.MutationsCounter;
import com.milaboratory.core.mutations.MutationsEnumerator;

public class MutationConsensusBuilder {
    final CoverageCounter coverage;
    final MutationsCounter mutations;

    public MutationConsensusBuilder(Range seqRange) {
        this.coverage = new CoverageCounter(seqRange);
        this.mutations = new MutationsCounter();
    }

    public void aggregate(Alignment<?> alignment, CoverageCounter.Provider coverageFunction) {
        this.coverage.aggregate(alignment.getSequence1Range(), coverageFunction);
        MutationsEnumerator enumerator = new MutationsEnumerator(alignment.getAbsoluteMutations());
        while (enumerator.next()) {
            this.mutations.adjust(alignment.getAbsoluteMutations(), enumerator, (int)coverageFunction.delta(Mutation.getPosition(enumerator.getOffset())));
        }
    }
}

