/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.milaboratory.core.Range;
import com.milaboratory.core.mutations.IO;
import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.MutationType;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.mutations.MutationsUtil;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.AminoAcidSequence;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.primitivio.annotations.Serializable;
import com.milaboratory.util.IntArrayList;
import java.util.Arrays;

@JsonSerialize(using=IO.JsonMutationsSerializer.class)
@JsonDeserialize(using=IO.JsonMutationsDeserializer.class)
@Serializable(by=IO.MutationsSerializer.class)
public final class Mutations<S extends Sequence<S>>
implements java.io.Serializable {
    final Alphabet<S> alphabet;
    final int[] mutations;
    public static final Mutations<NucleotideSequence> EMPTY_NUCLEOTIDE_MUTATIONS = new Mutations<NucleotideSequence>(NucleotideSequence.ALPHABET, new int[0]);
    public static final Mutations<AminoAcidSequence> EMPTY_AMINO_ACID_MUTATIONS = new Mutations<AminoAcidSequence>(AminoAcidSequence.ALPHABET, new int[0]);

    public Mutations(Alphabet<S> alphabet, IntArrayList mutations) {
        this(alphabet, mutations.toArray(), true);
    }

    public Mutations(Alphabet<S> alphabet, String encodedMutations) {
        this(alphabet, MutationsUtil.decode(encodedMutations, alphabet), true);
    }

    public Mutations(Alphabet<S> alphabet, int ... mutations) {
        if (!MutationsUtil.isSorted(mutations)) {
            throw new IllegalArgumentException("Not sorted according to positions.");
        }
        this.mutations = (int[])mutations.clone();
        this.alphabet = alphabet;
    }

    Mutations(Alphabet<S> alphabet, int[] mutations, boolean unsafe) {
        assert (unsafe);
        assert (MutationsUtil.isSorted(mutations));
        this.mutations = mutations;
        this.alphabet = alphabet;
    }

    public int size() {
        return this.mutations.length;
    }

    public Alphabet<S> getAlphabet() {
        return this.alphabet;
    }

    public int getMutation(int index) {
        return this.mutations[index];
    }

    public int[] getRAWMutations() {
        return (int[])this.mutations.clone();
    }

    public boolean isEmpty() {
        return this.mutations.length == 0;
    }

    public int getPositionByIndex(int index) {
        return Mutation.getPosition(this.mutations[index]);
    }

    public byte getFromAsCodeByIndex(int index) {
        return Mutation.getFrom(this.mutations[index]);
    }

    public byte getToAsCodeByIndex(int index) {
        return Mutation.getTo(this.mutations[index]);
    }

    public char getFromAsSymbolByIndex(int index) {
        return this.alphabet.codeToSymbol(this.getFromAsCodeByIndex(index));
    }

    public char getToAsSymbolByIndex(int index) {
        return this.alphabet.codeToSymbol(this.getToAsCodeByIndex(index));
    }

    public int getRawTypeByIndex(int index) {
        return Mutation.getRawTypeCode(this.mutations[index]);
    }

    public MutationType getTypeByIndex(int index) {
        return Mutation.getType(this.mutations[index]);
    }

    public boolean isCompatibleWith(S sequence) {
        return MutationsUtil.isCompatibleWithSequence(sequence, this.mutations);
    }

    public S mutate(S sequence) {
        int length = sequence.size();
        block9: for (int i : this.mutations) {
            switch (i & 0x60) {
                case 64: {
                    --length;
                    continue block9;
                }
                case 96: {
                    ++length;
                }
            }
        }
        SequenceBuilder<byte> builder = this.alphabet.createBuilder().ensureCapacity(length);
        int pointer = 0;
        int mutPointer = 0;
        while (pointer < sequence.size() || mutPointer < this.mutations.length) {
            int mut;
            if (mutPointer < this.mutations.length && (mut = this.mutations[mutPointer]) >>> 12 <= pointer) {
                switch (mut & 0x60) {
                    case 32: {
                        if ((mut >> 7 & 0x1F) != ((Sequence)sequence).codeAt(pointer)) {
                            throw new IllegalArgumentException("Mutation = " + Mutation.toString(((Sequence)sequence).getAlphabet(), mut) + " but seq[" + pointer + "]=" + ((Sequence)sequence).symbolAt(pointer));
                        }
                        ++pointer;
                        builder.append((byte)(mut & 0x1F));
                        ++mutPointer;
                        break;
                    }
                    case 64: {
                        if ((mut >> 7 & 0x1F) != ((Sequence)sequence).codeAt(pointer)) {
                            throw new IllegalArgumentException("Mutation = " + Mutation.toString(((Sequence)sequence).getAlphabet(), mut) + " but seq[" + pointer + "]=" + ((Sequence)sequence).symbolAt(pointer));
                        }
                        ++pointer;
                        ++mutPointer;
                        break;
                    }
                    case 96: {
                        builder.append((byte)(mut & 0x1F));
                        ++mutPointer;
                    }
                }
                continue;
            }
            builder.append(((Sequence)sequence).codeAt(pointer++));
        }
        return builder.createAndDestroy();
    }

    public int convertToSeq2Position(int seq1Position) {
        int result = seq1Position;
        block4: for (int mut : this.mutations) {
            int p = Mutation.getPosition(mut);
            if (p > seq1Position) {
                return result;
            }
            switch (mut & 0x60) {
                case 64: {
                    if (p == seq1Position) {
                        return -result - 1;
                    }
                    --result;
                    continue block4;
                }
                case 96: {
                    ++result;
                }
            }
        }
        return result;
    }

    public int convertToSeq1Position(int seq2Position) {
        int seq2p = 0;
        int prevSeq1p = 0;
        int prevSeq2p = 0;
        for (int mut : this.mutations) {
            int seq1p = Mutation.getPosition(mut);
            boolean onInsertion = false;
            switch (mut & 0x60) {
                case 64: {
                    --seq2p;
                    break;
                }
                case 96: {
                    onInsertion = true;
                    --seq1p;
                    ++seq2p;
                }
            }
            if ((seq2p += seq1p - prevSeq1p) == seq2Position && onInsertion) {
                return -1 - (seq2Position - prevSeq2p + prevSeq1p);
            }
            if (seq2p >= seq2Position) {
                return seq2Position - prevSeq2p + prevSeq1p;
            }
            prevSeq1p = seq1p;
            prevSeq2p = seq2p;
        }
        return seq2Position - prevSeq2p + prevSeq1p;
    }

    public int getLengthDelta() {
        int delta = 0;
        block4: for (int mut : this.mutations) {
            switch (mut & 0x60) {
                case 64: {
                    --delta;
                    continue block4;
                }
                case 96: {
                    ++delta;
                }
            }
        }
        return delta;
    }

    public Mutations<S> concat(Mutations<S> other) {
        return new MutationsBuilder<S>(this.alphabet, false).ensureCapacity(this.size() + other.size()).append(this).append(other).createAndDestroy();
    }

    public Mutations<S> combineWith(Mutations<S> other) {
        IntArrayList result = new IntArrayList(this.mutations.length + other.mutations.length);
        int p2 = 0;
        int position0 = 0;
        int delta = 0;
        block5: for (int p1 = 0; p1 < this.mutations.length; ++p1) {
            position0 = Mutation.getPosition(this.mutations[p1]);
            while (p2 < other.mutations.length && (Mutation.getPosition(other.mutations[p2]) < position0 + delta || Mutation.getPosition(other.mutations[p2]) == position0 + delta && Mutation.getRawTypeCode(other.mutations[p2]) == 96)) {
                Mutations.appendInCombine(result, Mutation.move(other.mutations[p2++], -delta));
            }
            switch (Mutation.getRawTypeCode(this.mutations[p1])) {
                case 96: {
                    if (p2 < other.mutations.length && Mutation.getPosition(other.mutations[p2]) == delta + position0) {
                        if (Mutation.getTo(this.mutations[p1]) != Mutation.getFrom(other.mutations[p2])) {
                            throw new IllegalArgumentException();
                        }
                        if (Mutation.isSubstitution(other.mutations[p2])) {
                            Mutations.appendInCombine(result, this.mutations[p1] & 0xFFFFFFE0 | other.mutations[p2] & 0x1F);
                        }
                        ++p2;
                    } else {
                        Mutations.appendInCombine(result, this.mutations[p1]);
                    }
                    ++delta;
                    continue block5;
                }
                case 32: {
                    if (p2 < other.mutations.length && Mutation.getPosition(other.mutations[p2]) == delta + position0) {
                        if (Mutation.getTo(this.mutations[p1]) != Mutation.getFrom(other.mutations[p2])) {
                            throw new IllegalArgumentException();
                        }
                        if (Mutation.isSubstitution(other.mutations[p2])) {
                            if (Mutation.getFrom(this.mutations[p1]) != Mutation.getTo(other.mutations[p2])) {
                                Mutations.appendInCombine(result, this.mutations[p1] & 0xFFFFFFE0 | other.mutations[p2] & 0x1F);
                            }
                        } else if (Mutation.isDeletion(other.mutations[p2])) {
                            Mutations.appendInCombine(result, Mutation.createDeletion(position0, Mutation.getFrom(this.mutations[p1])));
                        } else {
                            throw new RuntimeException("Insertion after Del. or Subs.");
                        }
                        ++p2;
                        continue block5;
                    }
                    Mutations.appendInCombine(result, this.mutations[p1]);
                    continue block5;
                }
                case 64: {
                    --delta;
                    Mutations.appendInCombine(result, this.mutations[p1]);
                }
            }
        }
        while (p2 < other.mutations.length) {
            Mutations.appendInCombine(result, Mutation.move(other.mutations[p2++], -delta));
        }
        return new Mutations<S>(this.alphabet, result.toArray(), true);
    }

    public Mutations<S> move(int offset) {
        int[] newMutations = new int[this.mutations.length];
        for (int i = 0; i < this.mutations.length; ++i) {
            newMutations[i] = Mutation.move(this.mutations[i], offset);
        }
        return new Mutations<S>(this.alphabet, newMutations, true);
    }

    public Mutations<S> extractRelativeMutationsForRange(Range range) {
        if (range.isReverse()) {
            throw new IllegalArgumentException("Reverse ranges are not supported by this method.");
        }
        return this.extractRelativeMutationsForRange(range.getFrom(), range.getTo());
    }

    public Mutations<S> extractRelativeMutationsForRange(int from, int to) {
        if (to < from) {
            throw new IllegalArgumentException("Reversed ranges are not supported.");
        }
        long indexRange = this.getIndexRange(from, to);
        if (indexRange == 0L) {
            return Mutations.empty(this.alphabet);
        }
        int fromIndex = (int)(indexRange >>> 32);
        int toIndex = (int)(indexRange & 0xFFFFFFFFFFFFFFFFL);
        if (from == 0 && fromIndex == 0 && toIndex == this.mutations.length) {
            return this;
        }
        int[] result = new int[toIndex - fromIndex];
        int offset = from == -1 ? 0 : -from << 12;
        int i = result.length - 1;
        int j = toIndex - 1;
        while (i >= 0) {
            result[i] = this.mutations[j] + offset;
            --i;
            --j;
        }
        return new Mutations<S>(this.alphabet, result, true);
    }

    public Mutations<S> extractAbsoluteMutationsForRange(Range range) {
        return this.extractAbsoluteMutationsForRange(range.getFrom(), range.getTo());
    }

    public Mutations<S> extractAbsoluteMutationsForRange(int from, int to) {
        if (to < from) {
            throw new IllegalArgumentException("Reversed ranges are not supported.");
        }
        long indexRange = this.getIndexRange(from, to);
        if (indexRange == 0L) {
            return Mutations.empty(this.alphabet);
        }
        int fromIndex = (int)(indexRange >>> 32);
        int toIndex = (int)(indexRange & 0xFFFFFFFFFFFFFFFFL);
        if (from == 0 && fromIndex == 0 && toIndex == this.mutations.length) {
            return this;
        }
        return new Mutations<S>(this.alphabet, Arrays.copyOfRange(this.mutations, fromIndex, toIndex), true);
    }

    public Mutations<S> removeMutationsInRanges(Range ... ranges) {
        Mutations<S> result = this;
        int offset = 0;
        int lastTo = 0;
        for (Range range : ranges) {
            if (range.getFrom() < lastTo) {
                throw new IllegalArgumentException("Ranges are not sorted.");
            }
            result = result.removeMutationsInRange(range.move(offset));
            offset -= range.length();
            lastTo = range.getTo();
        }
        return result;
    }

    public Mutations<S> removeMutationsInRange(Range range) {
        return this.removeMutationsInRange(range.getFrom(), range.getTo());
    }

    public Mutations<S> removeMutationsInRange(int from, int to) {
        int j;
        if (to < from) {
            throw new IllegalArgumentException("Reversed ranges are not supported.");
        }
        if (from == to) {
            return this;
        }
        long indexRange = this.getIndexRange(from, to);
        int fromIndex = (int)(indexRange >>> 32);
        int toIndex = (int)(indexRange & 0xFFFFFFFFFFFFFFFFL);
        if (fromIndex == 0 && toIndex == this.mutations.length) {
            return Mutations.empty(this.alphabet);
        }
        int[] result = new int[this.mutations.length - (toIndex - fromIndex)];
        int offset = from - to << 12;
        int i = 0;
        for (j = 0; j < fromIndex; ++j) {
            result[i++] = this.mutations[j];
        }
        for (j = toIndex; j < this.mutations.length; ++j) {
            result[i++] = this.mutations[j] + offset;
        }
        assert (i == result.length);
        return new Mutations<S>(this.alphabet, result, true);
    }

    private long getIndexRange(int from, int to) {
        if (from == to) {
            return 0L;
        }
        int fromIndex = this.firstMutationWithPosition(from);
        if (fromIndex < 0) {
            fromIndex = -fromIndex - 1;
        }
        while (fromIndex < this.mutations.length && this.mutations[fromIndex] >>> 12 == from && (this.mutations[fromIndex] & 0x60) == 96) {
            ++fromIndex;
        }
        int toIndex = this.firstMutationWithPosition(fromIndex, this.mutations.length, to);
        if (toIndex < 0) {
            toIndex = -toIndex - 1;
        }
        while (toIndex < this.mutations.length && this.mutations[toIndex] >>> 12 == to && (this.mutations[toIndex] & 0x60) == 96) {
            ++toIndex;
        }
        return (long)fromIndex << 32 | (long)toIndex;
    }

    public Mutations<S> invert() {
        if (this.mutations.length == 0) {
            return this;
        }
        int[] newMutations = new int[this.mutations.length];
        int delta = 0;
        for (int i = 0; i < this.mutations.length; ++i) {
            byte from = Mutation.getFrom(this.mutations[i]);
            byte to = Mutation.getTo(this.mutations[i]);
            int pos = Mutation.getPosition(this.mutations[i]);
            int type = Mutation.getRawTypeCode(this.mutations[i]);
            switch (type) {
                case 64: {
                    --delta;
                    type = 96;
                    ++pos;
                    break;
                }
                case 96: {
                    ++delta;
                    type = 64;
                    --pos;
                    break;
                }
            }
            newMutations[i] = Mutation.createMutation(type, pos + delta, (int)to, (int)from);
        }
        return new Mutations<S>(this.alphabet, newMutations, true);
    }

    public int countOfIndels() {
        int result = 0;
        for (int mutation : this.mutations) {
            switch (mutation & 0x60) {
                case 64: 
                case 96: {
                    ++result;
                }
            }
        }
        return result;
    }

    public int countOf(MutationType type) {
        int result = 0;
        for (int mutation : this.mutations) {
            if ((mutation & 0x60) != type.rawType) continue;
            ++result;
        }
        return result;
    }

    public Mutations<S> getRange(int from, int to) {
        return new Mutations<S>(this.alphabet, Arrays.copyOfRange(this.mutations, from, to));
    }

    public int firsMutationPosition() {
        if (this.isEmpty()) {
            return -1;
        }
        return Mutation.getPosition(this.mutations[0]);
    }

    public int lastMutationPosition() {
        if (this.isEmpty()) {
            return -1;
        }
        return Mutation.getPosition(this.mutations[this.mutations.length - 1]);
    }

    public Range getMutatedRange() {
        if (this.isEmpty()) {
            return null;
        }
        return new Range(this.firsMutationPosition(), this.lastMutationPosition());
    }

    public String toString() {
        if (this.mutations.length == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int mut : this.mutations) {
            builder.append(Mutation.toString(this.alphabet, mut) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }

    public String encode() {
        return MutationsUtil.encode(this.mutations, this.alphabet);
    }

    public String encode(String separator) {
        return MutationsUtil.encode(this.mutations, this.alphabet, separator);
    }

    public String encodeFixed() {
        return MutationsUtil.encodeFixed(this.mutations, this.alphabet);
    }

    public static Mutations<NucleotideSequence> decodeNuc(String string) {
        return Mutations.decode(string, NucleotideSequence.ALPHABET);
    }

    public static Mutations<AminoAcidSequence> decodeAA(String string) {
        return Mutations.decode(string, AminoAcidSequence.ALPHABET);
    }

    public static <S extends Sequence<S>> Mutations<S> decode(String string, Alphabet<S> alphabet) {
        return new Mutations<S>(alphabet, MutationsUtil.decode(string, alphabet), true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mutations mutations1 = (Mutations)o;
        if (this.alphabet != mutations1.alphabet) {
            return false;
        }
        return Arrays.equals(this.mutations, mutations1.mutations);
    }

    public int hashCode() {
        int result = this.alphabet.hashCode();
        result = 31 * result + Arrays.hashCode(this.mutations);
        return result;
    }

    public static int pabs(int position) {
        return position >= 0 ? position : -1 - position;
    }

    public int firstMutationWithPosition(int position) {
        return this.firstMutationWithPosition(0, this.mutations.length, position);
    }

    public int firstMutationWithPosition(int fromIndex, int toIndex, int position) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.mutations[mid] >>> 12;
            if (midVal < position) {
                low = mid + 1;
                continue;
            }
            if (midVal > position) {
                high = mid - 1;
                continue;
            }
            while (mid > 0 && this.mutations[mid - 1] >>> 12 == position) {
                --mid;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static void appendInCombine(IntArrayList result, int mutation) {
        if (Mutation.isSubstitution(mutation) || result.isEmpty()) {
            result.add(mutation);
        } else {
            int last = result.peek();
            if (Mutation.isSubstitution(last)) {
                result.add(mutation);
            } else {
                int mPosition;
                int lPosition = Mutation.getPosition(last);
                if (lPosition == (mPosition = Mutation.getPosition(mutation)) && Mutation.isInsertion(last) && Mutation.isDeletion(mutation)) {
                    Mutations.cfs(result, lPosition, Mutation.getFrom(mutation), Mutation.getTo(last));
                } else if (lPosition == mPosition - 1 && Mutation.isDeletion(last) && Mutation.isInsertion(mutation)) {
                    Mutations.cfs(result, lPosition, Mutation.getFrom(last), Mutation.getTo(mutation));
                } else {
                    result.add(mutation);
                }
            }
        }
    }

    private static void cfs(IntArrayList result, int position, int from, int to) {
        if (from == to) {
            result.pop();
        } else {
            result.set(result.size() - 1, Mutation.createSubstitution(position, from, to));
        }
    }

    public static <S extends Sequence<S>> Mutations<S> empty(Alphabet<S> alphabet) {
        if (alphabet == NucleotideSequence.ALPHABET) {
            return EMPTY_NUCLEOTIDE_MUTATIONS;
        }
        if (alphabet == AminoAcidSequence.ALPHABET) {
            return EMPTY_AMINO_ACID_MUTATIONS;
        }
        return new Mutations<S>(alphabet, new int[0]);
    }
}

