/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations;

import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsUtil;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.util.ArraysUtils;
import java.util.Arrays;

public final class MutationsBuilder<S extends Sequence<S>> {
    private final Alphabet<S> alphabet;
    private final boolean reversed;
    private int[] mutations = null;
    private int size = 0;

    public MutationsBuilder(Alphabet<S> alphabet, boolean reversed, int[] mutations, int size) {
        this.alphabet = alphabet;
        this.reversed = reversed;
        this.mutations = mutations;
        this.size = size;
    }

    public MutationsBuilder(Alphabet<S> alphabet) {
        this(alphabet, false);
    }

    public MutationsBuilder(Alphabet<S> alphabet, boolean reversed) {
        this.alphabet = alphabet;
        this.reversed = reversed;
    }

    public int get(int index) {
        return this.mutations[index];
    }

    public int size() {
        return this.size;
    }

    public void set(int index, int mutation) {
        this.mutations[index] = mutation;
    }

    public int getLast() {
        return this.mutations[this.size - 1];
    }

    public void removeLast() {
        --this.size;
    }

    private void ensureInternalCapacity(int newSize) {
        if (this.size == -1) {
            throw new IllegalStateException("Destroyed.");
        }
        if (this.mutations != null && this.mutations.length >= newSize) {
            return;
        }
        if (newSize == 0) {
            assert (this.mutations == null);
            return;
        }
        if (this.mutations == null) {
            this.mutations = new int[Math.max(newSize, 10)];
        }
        if (this.mutations.length < newSize) {
            this.mutations = Arrays.copyOf(this.mutations, Math.max(newSize, 3 * this.mutations.length / 2 + 1));
        }
    }

    public MutationsBuilder<S> ensureCapacity(int capacity) {
        if (this.size == -1) {
            throw new IllegalStateException("Destroyed.");
        }
        if (capacity > 0) {
            if (this.mutations == null) {
                this.mutations = new int[capacity];
            } else if (capacity > this.mutations.length) {
                this.mutations = Arrays.copyOf(this.mutations, capacity);
            }
        }
        return this;
    }

    public Mutations<S> createAndDestroy() {
        int[] m = this.mutations == null ? new int[]{} : (this.mutations.length == this.size ? this.mutations : Arrays.copyOf(this.mutations, this.size));
        this.mutations = null;
        this.size = -1;
        if (this.reversed) {
            ArraysUtils.reverse(m);
        }
        if (m.length > 1) {
            for (int i = 1; i < m.length; ++i) {
                if (Mutation.getPosition(m[i - 1]) <= Mutation.getPosition(m[i])) continue;
                throw new IllegalArgumentException("Mutations must be appended in descending/ascending order (position) depending on the value of reverse flag. Problem " + Mutation.encode(m[i - 1], this.alphabet) + ":" + Mutation.encode(m[i], this.alphabet) + " in " + MutationsUtil.encode(m, this.alphabet) + ".");
            }
        }
        return new Mutations<S>(this.alphabet, m, true);
    }

    public MutationsBuilder<S> append(Mutations<S> other) {
        this.append(other, 0, other.size());
        return this;
    }

    public MutationsBuilder<S> append(MutationsBuilder<S> other) {
        if (other.size == 0) {
            return this;
        }
        this.ensureInternalCapacity(this.size + other.size);
        System.arraycopy(other.mutations, 0, this.mutations, this.size, other.size);
        this.size += other.size;
        return this;
    }

    public MutationsBuilder<S> append(Mutations<S> other, int otherFrom, int length) {
        this.ensureInternalCapacity(this.size + length);
        if (length != 0) {
            System.arraycopy(other.mutations, otherFrom, this.mutations, this.size, length);
        }
        this.size += length;
        return this;
    }

    public MutationsBuilder<S> append(int[] other) {
        this.ensureInternalCapacity(this.size + other.length);
        for (int mutation : other) {
            this.mutations[this.size++] = mutation;
        }
        return this;
    }

    public MutationsBuilder<S> append(int mutation) {
        this.ensureInternalCapacity(this.size + 1);
        this.mutations[this.size++] = mutation;
        return this;
    }

    public MutationsBuilder<S> appendSubstitution(int position, int from, int to) {
        return this.append(Mutation.createSubstitution(position, from, to));
    }

    public MutationsBuilder<S> appendDeletion(int position, int from) {
        return this.append(Mutation.createDeletion(position, from));
    }

    public MutationsBuilder<S> appendInsertion(int position, int to) {
        return this.append(Mutation.createInsertion(position, to));
    }

    public MutationsBuilder<S> appendInsertion(int position, S insert) {
        this.ensureCapacity(this.size + insert.size());
        for (int i = 0; i < insert.size(); ++i) {
            this.append(Mutation.createInsertion(position, ((Sequence)insert).codeAt(i)));
        }
        return this;
    }

    public MutationsBuilder<S> appendDeletion(int position, int length, S originalSequence) {
        this.ensureCapacity(this.size + length);
        for (int i = 0; i < length; ++i) {
            this.append(Mutation.createDeletion(position + i, ((Sequence)originalSequence).codeAt(position + i)));
        }
        return this;
    }

    public MutationsBuilder<S> reverseRange(int from, int to) {
        ArraysUtils.reverse(this.mutations, from, to);
        return this;
    }

    public MutationsBuilder<S> clone() {
        return new MutationsBuilder<S>(this.alphabet, this.reversed, this.mutations == null ? null : (int[])this.mutations.clone(), this.size);
    }

    public String toString() {
        return ((MutationsBuilder)this.clone()).createAndDestroy().toString();
    }
}

