/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations;

import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsEnumerator;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.util.IntArrayList;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.custom_hash.TObjectIntCustomHashMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.strategy.HashingStrategy;
import java.util.Arrays;

public final class MutationsCounter {
    final TIntLongHashMap counter = new TIntLongHashMap();
    TObjectIntCustomHashMap<int[]> insertMapping = null;

    public void adjust(Mutations<?> mutations, int delta) {
        MutationsEnumerator enumerator = new MutationsEnumerator(mutations);
        while (enumerator.next()) {
            this.adjust(mutations, enumerator, delta);
        }
    }

    public void adjust(Mutations<?> mutations, MutationsEnumerator enumerator, int delta) {
        this.adjust(mutations.mutations, enumerator.getOffset(), enumerator.getLength(), delta);
    }

    void adjust(int[] mutationsArray, int offset, int length, int delta) {
        assert (length != 0);
        if (length == 1) {
            this.adjustSingleMutation(mutationsArray[offset], delta);
        } else {
            this.adjustLongInsert(Arrays.copyOfRange(mutationsArray, offset, offset + length), delta);
        }
    }

    public <S extends Sequence<S>> Mutations<S> build(Alphabet<S> alphabet, Filter filter) {
        IntArrayList mutations = new IntArrayList();
        TIntLongIterator it = this.counter.iterator();
        while (it.hasNext()) {
            it.advance();
            int mutation = it.key();
            long count = it.value();
            if ((mutation & 0x60) == 0 || !filter.accept(count, Mutation.getPosition(mutation), mutation, null)) continue;
            mutations.add(mutation);
        }
        if (this.insertMapping != null) {
            TObjectIntIterator itO = this.insertMapping.iterator();
            while (itO.hasNext()) {
                itO.advance();
                int[] muts = (int[])itO.key();
                long count = this.counter.get(itO.value());
                if (!filter.accept(count, Mutation.getPosition(muts[0]), 0, muts)) continue;
                mutations.addAll(muts);
            }
        }
        mutations.stableSort(Mutation.POSITION_COMPARATOR);
        return new Mutations<S>(alphabet, mutations);
    }

    private void adjustSingleMutation(int mutation, int delta) {
        this.counter.adjustOrPutValue(mutation, (long)delta, (long)delta);
    }

    private void adjustLongInsert(int[] insert, int delta) {
        int next;
        int mutCode;
        if (this.insertMapping == null) {
            this.insertMapping = new TObjectIntCustomHashMap((HashingStrategy)new IntArrayHashingStrategy(), 10, 0.5f, 0);
        }
        if ((mutCode = this.insertMapping.putIfAbsent((Object)insert, next = this.nextId())) == 0) {
            mutCode = next;
        }
        this.counter.adjustOrPutValue(mutCode, (long)delta, (long)delta);
    }

    private int nextId() {
        return this.insertMapping.size() + 1 << 7;
    }

    public static interface Filter {
        public boolean accept(long var1, int var3, int var4, int[] var5);
    }

    private static final class IntArrayHashingStrategy
    implements HashingStrategy<int[]> {
        private IntArrayHashingStrategy() {
        }

        public int computeHashCode(int[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(int[] o1, int[] o2) {
            return Arrays.equals(o1, o2);
        }
    }
}

