/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations;

import com.milaboratory.core.Range;
import com.milaboratory.core.alignment.AlignmentIteratorForward;
import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.AminoAcidSequence;
import com.milaboratory.core.sequence.NSequenceWithQuality;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.core.sequence.SequenceQualityBuilder;
import com.milaboratory.core.sequence.TranslationParameters;
import com.milaboratory.util.IntArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MutationsUtil {
    static final Map<Alphabet, Pattern> mutationPatterns = Collections.synchronizedMap(new HashMap());
    private static final Pattern btopPattern = Pattern.compile("([a-zA-Z]{2}|-[a-zA-Z]|[a-zA-Z]-|[0-9]+)");

    private MutationsUtil() {
    }

    public static NSequenceWithQuality mutate(NSequenceWithQuality seq, Mutations<NucleotideSequence> mutations) {
        NucleotideSequence sequence = (NucleotideSequence)seq.getSequence();
        SequenceQuality quality = seq.getQuality();
        int size = seq.size();
        int newSize = seq.size() + mutations.getLengthDelta();
        SequenceQualityBuilder qualityBuilder = (SequenceQualityBuilder)new SequenceQualityBuilder().ensureCapacity(newSize);
        SequenceBuilder<byte> sequenceBuilder = NucleotideSequence.ALPHABET.createBuilder().ensureCapacity(newSize);
        int pointer = 0;
        int mutPointer = 0;
        while (pointer < size || mutPointer < mutations.size()) {
            int mut;
            if (mutPointer < mutations.size() && (mut = mutations.getMutation(mutPointer)) >>> 12 <= pointer) {
                switch (mut & 0x60) {
                    case 32: {
                        if ((mut >> 7 & 0x1F) != sequence.codeAt(pointer)) {
                            throw new IllegalArgumentException("Mutation = " + Mutation.toString(sequence.getAlphabet(), mut) + " but seq[" + pointer + "]=" + sequence.symbolAt(pointer));
                        }
                        sequenceBuilder.append((byte)(mut & 0x1F));
                        qualityBuilder.append(quality.value(pointer));
                        ++pointer;
                        ++mutPointer;
                        break;
                    }
                    case 64: {
                        if ((mut >> 7 & 0x1F) != sequence.codeAt(pointer)) {
                            throw new IllegalArgumentException("Mutation = " + Mutation.toString(sequence.getAlphabet(), mut) + " but seq[" + pointer + "]=" + sequence.symbolAt(pointer));
                        }
                        ++pointer;
                        ++mutPointer;
                        break;
                    }
                    case 96: {
                        sequenceBuilder.append((byte)(mut & 0x1F));
                        if (pointer == 0) {
                            qualityBuilder.append(quality.value(pointer));
                        } else {
                            qualityBuilder.append((byte)((quality.value(pointer - 1) + quality.value(pointer)) / 2));
                        }
                        ++mutPointer;
                    }
                }
                continue;
            }
            qualityBuilder.append(quality.value(pointer));
            sequenceBuilder.append(sequence.codeAt(pointer++));
        }
        return new NSequenceWithQuality((NucleotideSequence)sequenceBuilder.createAndDestroy(), (SequenceQuality)qualityBuilder.createAndDestroy());
    }

    public static <S extends Sequence<S>> Mutations<S> shiftIndelsAtHomopolymers(S seq1, Mutations<S> mutations) {
        return MutationsUtil.shiftIndelsAtHomopolymers(seq1, 0, mutations);
    }

    public static <S extends Sequence<S>> Mutations<S> shiftIndelsAtHomopolymers(S seq1, int seq1From, Mutations<S> mutations) {
        int[] muts = (int[])mutations.mutations.clone();
        MutationsUtil.shiftIndelsAtHomopolymers(seq1, seq1From, muts);
        return new Mutations(mutations.alphabet, muts);
    }

    public static void shiftIndelsAtHomopolymers(Sequence seq1, int[] mutations) {
        MutationsUtil.shiftIndelsAtHomopolymers(seq1, 0, mutations);
    }

    public static void shiftIndelsAtHomopolymers(Sequence seq1, int seq1From, int[] mutations) {
        int prevPos = seq1From;
        for (int i = 0; i < mutations.length; ++i) {
            int code = mutations[i];
            if (!Mutation.isSubstitution(code)) {
                byte nt;
                int pos = Mutation.getPosition(code);
                int offset = 0;
                if (pos < seq1From) {
                    throw new IllegalArgumentException();
                }
                byte by = nt = Mutation.isDeletion(code) ? Mutation.getFrom(code) : Mutation.getTo(code);
                while (pos > prevPos && seq1.codeAt(pos - 1) == nt) {
                    --pos;
                    --offset;
                }
                mutations[i] = Mutation.move(code, offset);
                prevPos = Mutation.getPosition(mutations[i]);
                if (!Mutation.isDeletion(mutations[i])) continue;
                ++prevPos;
                continue;
            }
            prevPos = Mutation.getPosition(mutations[i]) + 1;
        }
    }

    public static boolean check(Mutations mutations) {
        return MutationsUtil.check(mutations.mutations);
    }

    public static boolean check(int[] mutations) {
        for (int i = 0; i < mutations.length; ++i) {
            if (i > 0) {
                if (Mutation.isDeletion(mutations[i - 1]) && Mutation.isInsertion(mutations[i]) && Mutation.getPosition(mutations[i - 1]) == Mutation.getPosition(mutations[i]) - 1) {
                    return false;
                }
                if (Mutation.isDeletion(mutations[i]) && Mutation.isInsertion(mutations[i - 1]) && Mutation.getPosition(mutations[i - 1]) == Mutation.getPosition(mutations[i])) {
                    return false;
                }
            }
            if (!Mutation.isSubstitution(mutations[i]) || Mutation.getFrom(mutations[i]) != Mutation.getTo(mutations[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(int[] mutations) {
        if (mutations.length == 0) {
            return true;
        }
        int position = Mutation.getPosition(mutations[0]);
        for (int i = 1; i < mutations.length; ++i) {
            int p = Mutation.getPosition(mutations[i]);
            if (p < position) {
                return false;
            }
            position = p;
        }
        return true;
    }

    public static <S extends Sequence> boolean isCompatibleWithSequence(S sequence, int[] mutations) {
        for (int mutation : mutations) {
            int position = Mutation.getPosition(mutation);
            if (!(Mutation.isInsertion(mutation) ? position >= sequence.size() + 1 : position >= sequence.size() || sequence.codeAt(position) != Mutation.getFrom(mutation))) continue;
            return false;
        }
        return true;
    }

    static String getMutationPatternStringForAlphabet(Alphabet alphabet) {
        StringBuilder sb = new StringBuilder();
        StringBuilder t = new StringBuilder("([\\Q");
        for (byte i = 0; i < alphabet.size(); i = (byte)(i + 1)) {
            t.append(alphabet.codeToSymbol(i));
        }
        t.append("\\E])");
        sb.append("S").append((CharSequence)t).append("(\\d+)").append((CharSequence)t);
        sb.append("|");
        sb.append("D").append((CharSequence)t).append("(\\d+)");
        sb.append("|");
        sb.append("I").append("(\\d+)").append((CharSequence)t);
        return sb.toString();
    }

    static Pattern getMutationPatternForAlphabet(Alphabet alphabet) {
        Pattern pattern = mutationPatterns.get(alphabet);
        if (pattern == null) {
            pattern = Pattern.compile(MutationsUtil.getMutationPatternStringForAlphabet(alphabet));
            mutationPatterns.put(alphabet, pattern);
        }
        return pattern;
    }

    public static String encode(int[] mutations, Alphabet alphabet) {
        return MutationsUtil.encode(mutations, alphabet, "");
    }

    public static String encode(int[] mutations, Alphabet alphabet, String separator) {
        if (mutations.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int mut : mutations) {
            builder.append(Mutation.encode(mut, alphabet)).append(separator);
        }
        builder.delete(builder.length() - separator.length(), builder.length());
        return builder.toString();
    }

    public static String encodeFixed(int[] mutations, Alphabet alphabet) {
        StringBuilder builder = new StringBuilder();
        for (int mut : mutations) {
            builder.append(Mutation.encodeFixed(mut, alphabet));
            builder.append(":");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static int[] decode(String mutations, Alphabet alphabet) {
        Matcher matcher = MutationsUtil.getMutationPatternForAlphabet(alphabet).matcher(mutations);
        IntArrayList list = new IntArrayList();
        while (matcher.find()) {
            switch (matcher.group(0).charAt(0)) {
                case 'S': {
                    list.add(Mutation.createSubstitution(Integer.parseInt(matcher.group(2)), alphabet.symbolToCode(matcher.group(1).charAt(0)), alphabet.symbolToCode(matcher.group(3).charAt(0))));
                    break;
                }
                case 'D': {
                    list.add(Mutation.createDeletion(Integer.parseInt(matcher.group(5)), alphabet.symbolToCode(matcher.group(4).charAt(0))));
                    break;
                }
                case 'I': {
                    list.add(Mutation.createInsertion(Integer.parseInt(matcher.group(6)), alphabet.symbolToCode(matcher.group(7).charAt(0))));
                }
            }
        }
        return list.toArray();
    }

    public static int[] btopDecode(String alignment, Alphabet alphabet) {
        Matcher matcher = btopPattern.matcher(alignment);
        IntArrayList mutations = new IntArrayList();
        int sPosition = 0;
        while (matcher.find()) {
            String g = matcher.group();
            if (MutationsUtil.isPositiveInteger(g)) {
                sPosition += Integer.parseInt(g);
                continue;
            }
            if (g.charAt(0) == '-') {
                mutations.add(Mutation.createDeletion(sPosition, alphabet.symbolToCodeWithException(g.charAt(1))));
                ++sPosition;
                continue;
            }
            if (g.charAt(1) == '-') {
                mutations.add(Mutation.createInsertion(sPosition, alphabet.symbolToCodeWithException(g.charAt(0))));
                continue;
            }
            mutations.add(Mutation.createSubstitution(sPosition, alphabet.symbolToCodeWithException(g.charAt(1)), alphabet.symbolToCodeWithException(g.charAt(0))));
            ++sPosition;
        }
        return mutations.toArray();
    }

    private static boolean isPositiveInteger(String str) {
        if (str.isEmpty()) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c > '/' && c < ':') continue;
            return false;
        }
        return true;
    }

    public static Mutations<AminoAcidSequence> nt2aa(NucleotideSequence seq1, Mutations<NucleotideSequence> mutations, TranslationParameters translationParameters) {
        return MutationsUtil.nt2aa(seq1, mutations, translationParameters, Integer.MAX_VALUE);
    }

    public static Mutations<AminoAcidSequence> nt2aa(NucleotideSequence seq1, Mutations<NucleotideSequence> mutations, TranslationParameters translationParameters, int maxShiftedTriplets) {
        AminoAcidSequence aaSeq1 = AminoAcidSequence.translate(seq1, translationParameters);
        NucleotideSequence seq2 = mutations.mutate(seq1);
        AminoAcidSequence aaSeq2 = AminoAcidSequence.translate(seq2, translationParameters);
        MutationsBuilder<AminoAcidSequence> result = new MutationsBuilder<AminoAcidSequence>(AminoAcidSequence.ALPHABET);
        int prevAAP2 = -1;
        int shiftedTriplets = 0;
        for (int aaP1 = 0; aaP1 <= aaSeq1.size(); ++aaP1) {
            int aaP2;
            if (aaP1 != aaSeq1.size()) {
                int ntP1 = AminoAcidSequence.convertAAPositionToNt(aaP1, seq1.size(), translationParameters);
                int ntP2 = mutations.convertToSeq2Position(ntP1);
                if (ntP2 < 0) {
                    ntP2 = -ntP2 - 2;
                }
                if (ntP2 < 0) {
                    aaP2 = -1;
                } else {
                    AminoAcidSequence.AminoAcidSequencePosition pos = AminoAcidSequence.convertNtPositionToAA(ntP2, seq2.size(), translationParameters);
                    if (pos == null) continue;
                    if (pos.positionInTriplet != 0 && shiftedTriplets++ > maxShiftedTriplets) {
                        return null;
                    }
                    aaP2 = pos.aminoAcidPosition;
                }
            } else {
                aaP2 = aaSeq2.size();
            }
            if (aaP2 == prevAAP2) {
                if (aaP1 >= aaSeq1.size()) continue;
                result.appendDeletion(aaP1, aaSeq1.codeAt(aaP1));
                continue;
            }
            if (aaP2 > prevAAP2 + 1) {
                for (int i = prevAAP2 + 1; i < aaP2; ++i) {
                    int m;
                    if (result.size() > 0 && Mutation.isSubstitution(m = result.getLast()) && Mutation.getPosition(m) == aaP1 - 1 && Mutation.getFrom(m) == aaSeq2.codeAt(i)) {
                        result.removeLast();
                        result.appendInsertion(aaP1 - 1, (AminoAcidSequence)Mutation.getTo(m));
                        continue;
                    }
                    result.appendInsertion(aaP1, (AminoAcidSequence)aaSeq2.codeAt(i));
                }
            }
            if (aaP1 < aaSeq1.size() && aaSeq2.codeAt(aaP2) != aaSeq1.codeAt(aaP1)) {
                result.appendSubstitution(aaP1, aaSeq1.codeAt(aaP1), aaSeq2.codeAt(aaP2));
            }
            prevAAP2 = aaP2;
        }
        return result.createAndDestroy();
    }

    public static int[] nt2IndividualAA(NucleotideSequence seq1, Mutations<NucleotideSequence> mutations, TranslationParameters translationParameters) {
        int[] result = new int[mutations.size()];
        for (int i = 0; i < mutations.size(); ++i) {
            Mutations<AminoAcidSequence> aaMuts;
            result[i] = mutations.getRawTypeByIndex(i) != 32 ? 0 : ((aaMuts = MutationsUtil.nt2aa(seq1, mutations.getRange(i, i + 1), translationParameters)).size() == 0 ? 0 : aaMuts.getMutation(0));
        }
        return result;
    }

    public static MutationsWitMapping nt2aaWithMapping(NucleotideSequence seq1, Mutations<NucleotideSequence> mutations, TranslationParameters translationParameters, int maxShiftedTriplets) {
        Mutations<AminoAcidSequence> aaMutations = MutationsUtil.nt2aa(seq1, mutations, translationParameters, maxShiftedTriplets);
        if (aaMutations == null) {
            return null;
        }
        int[] mapping = new int[mutations.size()];
        Arrays.fill(mapping, -1);
        AminoAcidSequence aaSeq1 = AminoAcidSequence.translate(seq1, translationParameters);
        NucleotideSequence seq2 = mutations.mutate(seq1);
        AminoAcidSequence aaSeq2 = AminoAcidSequence.translate(seq2, translationParameters);
        AlignmentIteratorForward<NucleotideSequence> ntIterator = new AlignmentIteratorForward<NucleotideSequence>(mutations, new Range(0, seq1.size()));
        AlignmentIteratorForward<AminoAcidSequence> aaIterator = new AlignmentIteratorForward<AminoAcidSequence>(aaMutations, new Range(0, aaSeq2.size()));
        boolean activeAAIterator = aaIterator.advance();
        while (ntIterator.advance()) {
            if (ntIterator.getCurrentMutation() == 0) continue;
            AminoAcidSequence.AminoAcidSequencePosition aaSeq1Position = AminoAcidSequence.convertNtPositionToAA(ntIterator.getSeq1Position(), seq1.size(), translationParameters);
            AminoAcidSequence.AminoAcidSequencePosition aaSeq2Position = AminoAcidSequence.convertNtPositionToAA(ntIterator.getSeq2Position(), seq2.size(), translationParameters);
            if (aaSeq1Position == null || aaSeq2Position == null || !activeAAIterator) continue;
            do {
                if ((aaSeq1Position.aminoAcidPosition != aaIterator.getSeq1Position() || aaSeq2Position.aminoAcidPosition > aaIterator.getSeq2Position()) && (aaSeq1Position.aminoAcidPosition > aaIterator.getSeq1Position() || aaSeq2Position.aminoAcidPosition != aaIterator.getSeq2Position()) || aaIterator.getCurrentMutation() == 0) continue;
                mapping[ntIterator.getMutationsPointer()] = aaIterator.getMutationsPointer();
            } while ((aaSeq1Position.aminoAcidPosition > aaIterator.getSeq1Position() || aaSeq2Position.aminoAcidPosition > aaIterator.getSeq2Position()) && (activeAAIterator = aaIterator.advance()));
        }
        return new MutationsWitMapping(aaMutations, mapping);
    }

    public static MutationNt2AADescriptor[] nt2aaDetailed(NucleotideSequence seq1, Mutations<NucleotideSequence> mutations, TranslationParameters translationParameters, int maxShiftedTriplets) {
        MutationsWitMapping mutationsWitMapping = MutationsUtil.nt2aaWithMapping(seq1, mutations, translationParameters, maxShiftedTriplets);
        int[] individualMutations = MutationsUtil.nt2IndividualAA(seq1, mutations, translationParameters);
        MutationNt2AADescriptor[] result = new MutationNt2AADescriptor[mutations.size()];
        for (int i = 0; i < mutations.size(); ++i) {
            result[i] = new MutationNt2AADescriptor(mutations.getMutation(i), individualMutations[i], mutationsWitMapping.mapping[i] == -1 ? 0 : mutationsWitMapping.mutations.getMutation(mutationsWitMapping.mapping[i]));
        }
        return result;
    }

    public static final class MutationsWitMapping {
        public final Mutations<AminoAcidSequence> mutations;
        public final int[] mapping;

        public MutationsWitMapping(Mutations<AminoAcidSequence> mutations, int[] mapping) {
            this.mutations = mutations;
            this.mapping = mapping;
        }
    }

    public static final class MutationNt2AADescriptor {
        public final int originalNtMutation;
        public final int individualAAMutation;
        public final int cumulativeAAMutation;

        public MutationNt2AADescriptor(int originalNtMutation, int individualAAMutation, int cumulativeAAMutation) {
            this.originalNtMutation = originalNtMutation;
            this.individualAAMutation = individualAAMutation;
            this.cumulativeAAMutation = cumulativeAAMutation;
        }

        public String toString() {
            return Mutation.encode(this.originalNtMutation, NucleotideSequence.ALPHABET) + ":" + (this.individualAAMutation == 0 ? "" : Mutation.encode(this.individualAAMutation, AminoAcidSequence.ALPHABET)) + ":" + (this.cumulativeAAMutation == 0 ? "" : Mutation.encode(this.cumulativeAAMutation, AminoAcidSequence.ALPHABET));
        }
    }
}

