/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations.generator;

import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.generator.NucleotideMutationModel;
import com.milaboratory.core.mutations.generator.SubstitutionModel;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;

public final class GenericNucleotideMutationModel
implements NucleotideMutationModel,
Serializable {
    private final RandomGenerator generator;
    private final double[] events;
    private final double insertionProbability;

    public GenericNucleotideMutationModel(SubstitutionModel substitutionModel, double deletionProbability, double insertionProbability) {
        this(substitutionModel, deletionProbability, insertionProbability, System.currentTimeMillis());
    }

    public GenericNucleotideMutationModel(SubstitutionModel substitutionModel, double deletionProbability, double insertionProbability, long seed) {
        this.generator = new Well19937c(seed);
        this.insertionProbability = insertionProbability;
        this.events = new double[20];
        for (int i = 0; i < 4; ++i) {
            double sum = insertionProbability;
            this.events[i * 5] = sum += deletionProbability;
            double noEventProbability = 1.0 - sum - substitutionModel.getTotalSubstitutionProbability(i);
            for (int j = 0; j < 4; ++j) {
                this.events[i * 5 + 1 + j] = i != j ? (sum += substitutionModel.getProbability(i, j)) : (sum += noEventProbability);
            }
            assert (sum <= 1.0001 & sum >= 0.9999);
        }
    }

    GenericNucleotideMutationModel(double[] events, double insertionProbability) {
        this(events, insertionProbability, System.currentTimeMillis());
    }

    GenericNucleotideMutationModel(double[] events, double insertionProbability, long seed) {
        this.generator = new Well19937c(seed);
        this.events = events;
        this.insertionProbability = insertionProbability;
    }

    @Override
    public int generateMutation(int position, int inputLetter) {
        double r = this.generator.nextDouble();
        if (this.insertionProbability > r) {
            return Mutation.createInsertion(position, this.generator.nextInt(4));
        }
        if (inputLetter >= 0) {
            int event = Arrays.binarySearch(this.events, inputLetter * 5, (inputLetter + 1) * 5, r);
            if (event < 0) {
                event = -event - 1;
            }
            if ((event -= inputLetter * 5) == 0) {
                return Mutation.createDeletion(position, inputLetter);
            }
            if (event - 1 != inputLetter) {
                return Mutation.createSubstitution(position, inputLetter, event - 1);
            }
        }
        return 0;
    }

    @Override
    public GenericNucleotideMutationModel multiplyProbabilities(double factor) {
        double[] newEvents = new double[20];
        for (int i = 0; i < 20; ++i) {
            newEvents[i] = this.events[i] * factor;
        }
        for (int i = 0; i < 4; ++i) {
            double delta = newEvents[(i + 1) * 5 - 1] - 1.0;
            for (int j = i + 1; j < 5; ++j) {
                int n = i * 5 + j;
                newEvents[n] = newEvents[n] - delta;
            }
        }
        return new GenericNucleotideMutationModel(newEvents, this.insertionProbability * factor, this.generator.nextLong());
    }

    @Override
    public void reseed(long seed) {
        this.generator.setSeed(seed);
    }

    @Override
    public NucleotideMutationModel clone() {
        return new GenericNucleotideMutationModel(this.events, this.insertionProbability);
    }
}

