/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations.generator;

import com.milaboratory.core.Range;
import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.mutations.MutationsBuilder;
import com.milaboratory.core.mutations.generator.NucleotideMutationModel;
import com.milaboratory.core.sequence.NucleotideSequence;

public final class MutationsGenerator {
    private MutationsGenerator() {
    }

    public static Mutations<NucleotideSequence> generateMutations(NucleotideSequence sequence, NucleotideMutationModel model, Range range) {
        return MutationsGenerator.generateMutations(sequence, model, range.getFrom(), range.getTo());
    }

    public static Mutations<NucleotideSequence> generateMutations(NucleotideSequence sequence, NucleotideMutationModel model, int from, int to) {
        int mut;
        MutationsBuilder<NucleotideSequence> builder = new MutationsBuilder<NucleotideSequence>(NucleotideSequence.ALPHABET);
        int previous = 0;
        for (int i = from; i < to; ++i) {
            mut = model.generateMutation(i, sequence.codeAt(i));
            if (mut != 0) {
                switch (Mutation.getRawTypeCode(mut)) {
                    case 32: {
                        builder.append(mut);
                        break;
                    }
                    case 64: {
                        if (Mutation.getRawTypeCode(previous) == 96) {
                            mut = 0;
                            break;
                        }
                        builder.append(mut);
                        break;
                    }
                    case 96: {
                        if (Mutation.getRawTypeCode(previous) == 64) {
                            mut = 0;
                            break;
                        }
                        builder.append(mut);
                        --i;
                    }
                }
            }
            previous = mut;
        }
        mut = model.generateMutation(to, -1);
        if (Mutation.getRawTypeCode(mut) == 96 && Mutation.getRawTypeCode(previous) != 64) {
            builder.append(mut);
        }
        return builder.createAndDestroy();
    }

    public static Mutations<NucleotideSequence> generateMutations(NucleotideSequence sequence, NucleotideMutationModel model) {
        return MutationsGenerator.generateMutations(sequence, model, 0, sequence.size());
    }
}

