/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations.generator;

import com.milaboratory.core.mutations.Mutation;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.random.RandomGenerator;

public final class SubstitutionModel
implements Serializable {
    final int size;
    final double[] probabilities;
    final double[] cdf;

    public SubstitutionModel(double[] probabilities) {
        int j;
        double sum;
        int i;
        this.size = (int)Math.round(Math.sqrt(probabilities.length));
        if (probabilities.length != this.size * this.size) {
            throw new IllegalArgumentException();
        }
        this.probabilities = (double[])probabilities.clone();
        for (i = 0; i < this.size; ++i) {
            sum = 0.0;
            for (j = 0; j < this.size; ++j) {
                sum += this.probabilities[i * this.size + j];
            }
            int n = i * this.size + i;
            double d = this.probabilities[n] = this.probabilities[n] - (sum - 1.0);
            if (!(d < 0.0)) continue;
            throw new IllegalArgumentException();
        }
        this.cdf = new double[this.size * this.size];
        for (i = 0; i < this.size; ++i) {
            sum = 0.0;
            for (j = 0; j < this.size; ++j) {
                this.cdf[i * this.size + j] = sum += this.probabilities[i * this.size + j];
            }
            assert (sum <= 1.001 & sum >= 0.9999);
        }
    }

    public SubstitutionModel multiplyProbabilities(double factor) {
        double[] newProbabilities = new double[this.size * this.size];
        for (int i = this.size * this.size - 1; i >= 0; --i) {
            newProbabilities[i] = this.probabilities[i] * factor;
        }
        return new SubstitutionModel(newProbabilities);
    }

    public int sample(RandomGenerator generator, int letter) {
        double value = generator.nextDouble();
        int index = Arrays.binarySearch(this.cdf, letter * this.size, (letter + 1) * this.size, value);
        if (index < 0) {
            index = -index - 1;
        }
        assert ((index -= letter * this.size) < this.size);
        return index;
    }

    public int sampleAsMutation(RandomGenerator generator, int position, int letter) {
        double value = generator.nextDouble();
        int index = Arrays.binarySearch(this.cdf, letter * this.size, (letter + 1) * this.size, value);
        if (index < 0) {
            index = -index - 1;
        }
        assert ((index -= letter * this.size) < this.size);
        if (index != letter) {
            return Mutation.createSubstitution(position, letter, index);
        }
        return 0;
    }

    public double getTotalSubstitutionProbability(int letter) {
        return 1.0 - this.probabilities[letter * this.size + letter];
    }

    public double getProbability(int fromLetter, int toLetter) {
        return this.probabilities[fromLetter * this.size + toLetter];
    }
}

