/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations.generator;

import com.milaboratory.core.mutations.generator.SubstitutionModel;
import com.milaboratory.core.mutations.generator.SubstitutionModelBuilder;
import org.apache.commons.math3.random.RandomGenerator;

public final class SubstitutionModels {
    private SubstitutionModels() {
    }

    public static SubstitutionModel getEmpiricalNucleotideSubstitutionModel() {
        SubstitutionModelBuilder builder = new SubstitutionModelBuilder(4);
        builder.setProbability(0, 1, 0.00267);
        builder.setProbability(0, 2, 9.0E-5);
        builder.setProbability(0, 3, 0.0019);
        builder.setProbability(1, 0, 7.9E-4);
        builder.setProbability(1, 2, 1.0E-4);
        builder.setProbability(1, 3, 0.00234);
        builder.setProbability(2, 0, 0.0);
        builder.setProbability(2, 1, 1.7E-4);
        builder.setProbability(2, 3, 0.00162);
        builder.setProbability(3, 0, 6.0E-5);
        builder.setProbability(3, 1, 1.9E-4);
        builder.setProbability(3, 2, 0.00119);
        return builder.build();
    }

    public static SubstitutionModel getEmpiricalNucleotideSubstitutionModelWithNoise(RandomGenerator rd, double minFactor, double maxFactor) {
        SubstitutionModelBuilder builder = new SubstitutionModelBuilder(4);
        double l = maxFactor - minFactor;
        builder.setProbability(0, 1, 0.00267 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(0, 2, 9.0E-5 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(0, 3, 0.0019 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(1, 0, 7.9E-4 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(1, 2, 1.0E-4 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(1, 3, 0.00234 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(2, 0, 1.0E-5 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(2, 1, 1.7E-4 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(2, 3, 0.00162 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(3, 0, 6.0E-5 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(3, 1, 1.9E-4 * (minFactor + l * rd.nextDouble()));
        builder.setProbability(3, 2, 0.00119 * (minFactor + l * rd.nextDouble()));
        return builder.build();
    }

    public static SubstitutionModel getUniformNucleotideSubstitutionModel(double substitutionProbability) {
        SubstitutionModelBuilder builder = new SubstitutionModelBuilder(4);
        for (int i = 0; i < 4; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                builder.setProbability(i, j, substitutionProbability / 3.0);
                builder.setProbability(j, i, substitutionProbability / 3.0);
            }
        }
        return builder.build();
    }
}

