/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.mutations.generator;

import com.milaboratory.core.mutations.Mutation;
import com.milaboratory.core.mutations.MutationType;
import com.milaboratory.core.mutations.Mutations;
import com.milaboratory.core.sequence.Sequence;
import org.apache.commons.math3.random.RandomGenerator;

public class UniformMutationsGenerator {
    private static final MutationType[] types = MutationType.values();

    public static <S extends Sequence<S>> Mutations<S> createUniformMutationAsObject(S sequence, RandomGenerator generator) {
        return new Mutations<S>(sequence.getAlphabet(), UniformMutationsGenerator.createUniformMutation(sequence, generator));
    }

    public static <S extends Sequence<S>> int createUniformMutation(S sequence, RandomGenerator generator) {
        return UniformMutationsGenerator.createUniformMutation(sequence, generator, types[generator.nextInt(3)]);
    }

    public static <S extends Sequence<S>> Mutations<S> createUniformMutationAsObject(S sequence, RandomGenerator generator, MutationType type) {
        return new Mutations<S>(sequence.getAlphabet(), UniformMutationsGenerator.createUniformMutation(sequence, generator, type));
    }

    public static <S extends Sequence<S>> int createUniformMutation(S sequence, RandomGenerator generator, MutationType type) {
        if (sequence.containWildcards()) {
            throw new IllegalArgumentException("Sequences with wildcards are not supported.");
        }
        int alphabetSize = sequence.getAlphabet().basicSize();
        switch (type) {
            case Substitution: {
                int position = generator.nextInt(sequence.size());
                byte from = sequence.codeAt(position);
                byte to = (byte)((from + 1 + generator.nextInt(alphabetSize - 1)) % alphabetSize);
                assert (from != to);
                return Mutation.createSubstitution(position, from, to);
            }
            case Deletion: {
                int position = generator.nextInt(sequence.size());
                byte from = sequence.codeAt(position);
                return Mutation.createDeletion(position, from);
            }
            case Insertion: {
                int position = generator.nextInt(sequence.size() + 1);
                byte to = (byte)generator.nextInt(alphabetSize);
                return Mutation.createInsertion(position, to);
            }
        }
        throw new NullPointerException();
    }
}

