/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.core.sequence.AbstractArrayAlphabet;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import java.io.Serializable;
import java.util.Arrays;

abstract class AbstractArraySequence<S extends AbstractArraySequence<S>>
extends Sequence<S>
implements Serializable {
    protected final byte[] data;

    protected AbstractArraySequence(String sequence) {
        this.data = AbstractArraySequence.dataFromChars(this.getAlphabet(), sequence.toCharArray());
    }

    protected AbstractArraySequence(char[] sequence) {
        this.data = AbstractArraySequence.dataFromChars(this.getAlphabet(), sequence);
    }

    protected AbstractArraySequence(byte[] data) {
        this.data = data;
    }

    @Override
    public abstract AbstractArrayAlphabet<S> getAlphabet();

    @Override
    public byte codeAt(int position) {
        return this.data[position];
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public byte[] asArray() {
        return (byte[])this.data.clone();
    }

    @Override
    public S getRange(int from, int to) {
        if (from == 0 && to == this.data.length) {
            return (S)this;
        }
        if (from > to || to > this.data.length) {
            throw new IndexOutOfBoundsException();
        }
        return ((AbstractArrayAlphabet)this.getAlphabet()).createUnsafe(Arrays.copyOfRange(this.data, from, to));
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.data, ((AbstractArraySequence)o).data);
    }

    @Override
    public final int hashCode() {
        int result = this.getAlphabet().hashCode();
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    protected static byte[] dataFromChars(Alphabet alphabet, char[] chars) {
        byte[] data = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            data[i] = alphabet.symbolToCode(chars[i]);
            if (data[i] != -1) continue;
            throw new IllegalArgumentException("Unknown symbol \"" + chars[i] + "\"");
        }
        return data;
    }
}

