/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.milaboratory.core.sequence.Alphabets;
import com.milaboratory.core.sequence.IO;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.core.sequence.Wildcard;
import com.milaboratory.primitivio.annotations.Serializable;
import com.milaboratory.util.HashFunctions;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TCharByteHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@JsonSerialize(using=Alphabets.Serializer.class)
@JsonDeserialize(using=Alphabets.Deserializer.class)
@Serializable(by=IO.AlphabetSerializer.class)
public abstract class Alphabet<S extends Sequence<S>>
implements java.io.Serializable {
    private final byte alphabetId;
    private final String alphabetName;
    private final int hashCode;
    private final int countOfBasicLetters;
    private final char[] codeToSymbol;
    private final Wildcard[] codeToWildcard;
    private final List<Wildcard> wildcardsList;
    private final TCharByteHashMap symbolToCode;
    private final Wildcard wildcardForAnyLetter;
    private final TLongObjectMap<Wildcard> basicMaskToWildcard;
    private volatile S empty;

    Alphabet(String alphabetName, byte alphabetId, int countOfBasicLetters, Wildcard wildcardForAnyLetter, Wildcard ... wildcards) {
        this.alphabetName = alphabetName;
        this.alphabetId = alphabetId;
        this.hashCode = HashFunctions.JenkinWang32shift(alphabetId);
        this.countOfBasicLetters = countOfBasicLetters;
        this.wildcardForAnyLetter = wildcardForAnyLetter;
        int size = wildcards.length;
        this.codeToSymbol = new char[size];
        Arrays.fill(this.codeToSymbol, '\uffff');
        this.codeToWildcard = new Wildcard[size];
        this.symbolToCode = new TCharByteHashMap(10, 0.5f, '\uffff', -1);
        this.basicMaskToWildcard = new TLongObjectHashMap();
        for (Wildcard wildcard : wildcards) {
            if (wildcard.isBasic() && wildcard.getCode() >= countOfBasicLetters) {
                throw new IllegalArgumentException("Definite letter outside countOfPureLetters range.");
            }
            if (this.codeToSymbol[wildcard.getCode()] != '\uffff') {
                throw new IllegalArgumentException("Duplicate code.");
            }
            this.codeToSymbol[wildcard.getCode()] = wildcard.getSymbol();
            this.codeToWildcard[wildcard.getCode()] = wildcard;
            this.symbolToCode.put(wildcard.getSymbol(), wildcard.getCode());
            this.symbolToCode.put(Character.toLowerCase(wildcard.getSymbol()), wildcard.getCode());
            this.basicMaskToWildcard.put(wildcard.getBasicMask(), (Object)wildcard);
        }
        for (int i = 0; i < this.codeToSymbol.length; ++i) {
            if (this.codeToSymbol[i] != '\uffff') continue;
            throw new IllegalArgumentException("Symbol for code " + i + " is not set.");
        }
        this.wildcardsList = Collections.unmodifiableList(Arrays.asList(this.codeToWildcard));
    }

    public final int size() {
        return this.codeToSymbol.length;
    }

    public final int basicSize() {
        return this.countOfBasicLetters;
    }

    public final boolean isWildcard(byte code) {
        return code >= this.basicSize();
    }

    public final Wildcard codeToWildcard(byte code) {
        return this.codeToWildcard[code];
    }

    public final Wildcard symbolToWildcard(char symbol) {
        return this.codeToWildcard[this.symbolToCode.get(symbol)];
    }

    public final List<Wildcard> getAllWildcards() {
        return this.wildcardsList;
    }

    public final Wildcard getWildcardForAnyLetter() {
        return this.wildcardForAnyLetter;
    }

    public Wildcard maskToWildcard(long basicMask) {
        return (Wildcard)this.basicMaskToWildcard.get(basicMask);
    }

    public final char codeToSymbol(byte code) {
        return this.codeToSymbol[code];
    }

    public byte symbolToCode(char symbol) {
        return this.symbolToCode.get(symbol);
    }

    public final byte symbolToCodeWithException(char symbol) {
        byte b = this.symbolToCode(symbol);
        if (b == -1) {
            throw new IllegalArgumentException("Unknown letter '" + symbol + "'");
        }
        return b;
    }

    public abstract SequenceBuilder<S> createBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getEmptySequence() {
        if (this.empty == null) {
            Alphabet alphabet = this;
            synchronized (alphabet) {
                if (this.empty == null) {
                    this.empty = this.createBuilder().createAndDestroy();
                }
            }
        }
        return this.empty;
    }

    public final String getAlphabetName() {
        return this.alphabetName;
    }

    public final byte getId() {
        return this.alphabetId;
    }

    public final S parse(String string) {
        SequenceBuilder<byte> builder = this.createBuilder().ensureCapacity(string.length());
        for (int i = 0; i < string.length(); ++i) {
            byte code = this.symbolToCode(string.charAt(i));
            if (code == -1) {
                throw new IllegalArgumentException("Letter '" + string.charAt(i) + "' is not defined in '" + this.toString() + "'.");
            }
            builder.append(code);
        }
        return builder.createAndDestroy();
    }

    public final String toString() {
        return "Alphabet{" + this.alphabetName + '}';
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new AlphabetSerialization(this.alphabetId);
    }

    protected static class AlphabetSerialization
    implements java.io.Serializable {
        final byte id;

        public AlphabetSerialization() {
            this.id = 0;
        }

        public AlphabetSerialization(byte id) {
            this.id = id;
        }

        private Object readResolve() throws ObjectStreamException {
            return Alphabets.getById(this.id);
        }
    }
}

