/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.AminoAcidAlphabet;
import com.milaboratory.core.sequence.NucleotideAlphabet;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Alphabets {
    private static final Map<String, Alphabet> alphabetsByName = new HashMap<String, Alphabet>();
    private static final TIntObjectHashMap<Alphabet> alphabetsById = new TIntObjectHashMap(10, 0.5f, -128);

    private Alphabets() {
    }

    public static void register(Alphabet alphabet) {
        if (alphabetsByName.put(alphabet.getAlphabetName(), alphabet) != null) {
            throw new IllegalStateException("Alphabet with this name is already registered.");
        }
        if (alphabetsById.put((int)alphabet.getId(), (Object)alphabet) != null) {
            throw new IllegalStateException("Alphabet with this id is already registered.");
        }
    }

    public static Alphabet getByName(String name) {
        return alphabetsByName.get(name);
    }

    public static Alphabet getByFirstLetterOfName(char letter) {
        letter = Character.toLowerCase(letter);
        for (Alphabet alphabet : alphabetsByName.values()) {
            if (alphabet.getAlphabetName().charAt(0) != letter) continue;
            return alphabet;
        }
        throw new IllegalArgumentException("No alphabet starting with letter: " + letter);
    }

    public static Alphabet getById(byte id) {
        return (Alphabet)alphabetsById.get((int)id);
    }

    public static Collection<Alphabet> getAll() {
        return Collections.unmodifiableCollection(alphabetsByName.values());
    }

    static {
        Alphabets.register(NucleotideAlphabet.INSTANCE);
        Alphabets.register(AminoAcidAlphabet.INSTANCE);
    }

    public static final class Serializer
    extends JsonSerializer<Alphabet> {
        public void serialize(Alphabet value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getAlphabetName());
        }
    }

    public static final class Deserializer
    extends JsonDeserializer<Alphabet> {
        public Alphabet deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return Alphabets.getByName((String)jp.readValueAs(String.class));
        }

        public Alphabet getEmptyValue(DeserializationContext context) {
            return NucleotideAlphabet.INSTANCE;
        }

        public Alphabet getNullValue(DeserializationContext context) {
            return NucleotideAlphabet.INSTANCE;
        }
    }
}

