/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.milaboratory.core.sequence.AbstractArraySequence;
import com.milaboratory.core.sequence.AminoAcidAlphabet;
import com.milaboratory.core.sequence.GeneticCode;
import com.milaboratory.core.sequence.IO;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.TranslationParameters;

@JsonSerialize(using=IO.AASeqSerializer.class)
@JsonDeserialize(using=IO.AASeqDeserializer.class)
public final class AminoAcidSequence
extends AbstractArraySequence<AminoAcidSequence> {
    public static final AminoAcidSequence EMPTY = new AminoAcidSequence(new byte[0], true);
    public static final AminoAcidAlphabet ALPHABET = AminoAcidAlphabet.INSTANCE;

    public AminoAcidSequence(byte[] data) {
        super((byte[])data.clone());
    }

    public AminoAcidSequence(String sequence) {
        super(sequence);
    }

    AminoAcidSequence(byte[] data, boolean unsafe) {
        super(data);
        assert (unsafe);
    }

    @Override
    public AminoAcidAlphabet getAlphabet() {
        return ALPHABET;
    }

    public boolean containStops() {
        for (byte b : this.data) {
            if (b != 0) continue;
            return true;
        }
        return false;
    }

    public int numberOfStops() {
        int count = 0;
        for (byte b : this.data) {
            if (b != 0) continue;
            ++count;
        }
        return count;
    }

    public static int getTriplet(NucleotideSequence nSequence, int tripletStart) {
        int triplet = nSequence.codeAt(tripletStart) << 4 | nSequence.codeAt(tripletStart + 1) << 2 | nSequence.codeAt(tripletStart + 2);
        return triplet;
    }

    public static byte getAminoAcid(NucleotideSequence nSequence, int tripletStart) {
        return GeneticCode.getAminoAcid(AminoAcidSequence.getTriplet(nSequence, tripletStart));
    }

    public static AminoAcidSequence translate(NucleotideSequence sequence, int frame) {
        return AminoAcidSequence.translate((NucleotideSequence)sequence.getRange(frame, frame + (sequence.size() - frame) / 3 * 3));
    }

    public static AminoAcidSequence translate(NucleotideSequence sequence) {
        if (sequence.size() % 3 != 0) {
            throw new IllegalArgumentException("Only nucleotide sequences with size multiple of three are supported (in-frame).");
        }
        byte[] aaData = new byte[sequence.size() / 3];
        GeneticCode.translate(aaData, 0, sequence, 0, sequence.size());
        return new AminoAcidSequence(aaData, true);
    }

    public static int convertAAPositionToNt(int aaPosition, int ntSequenceLength, TranslationParameters translationParameters) {
        if (translationParameters.fromLeft == null) {
            int aaLength = ntSequenceLength / 3;
            int leftAALength = (aaLength + 1) / 2;
            int rightAALength = aaLength - leftAALength;
            int lastLeftNt = ntSequenceLength - rightAALength * 3;
            if (aaPosition < (leftAALength = (lastLeftNt + 2) / 3)) {
                return aaPosition * 3;
            }
            return lastLeftNt + (aaPosition - leftAALength) * 3;
        }
        if (translationParameters.fromLeft.booleanValue()) {
            byte offset = translationParameters.frame;
            if (aaPosition == 0) {
                if (translationParameters.includeIncomplete) {
                    return 0;
                }
                return offset;
            }
            if (offset != 0 && translationParameters.includeIncomplete) {
                --aaPosition;
            }
            return offset + aaPosition * 3;
        }
        return AminoAcidSequence.convertAAPositionToNt(aaPosition, ntSequenceLength, translationParameters.convertToLeftBound(ntSequenceLength));
    }

    public static int convertAAPositionToNtFromCenter(int aaPosition, int ntSequenceLength) {
        return AminoAcidSequence.convertAAPositionToNt(aaPosition, ntSequenceLength, TranslationParameters.FromCenter);
    }

    public static int convertAAPositionToNtFromLeft(int aaPosition, int ntSequenceLength) {
        return AminoAcidSequence.convertAAPositionToNt(aaPosition, ntSequenceLength, TranslationParameters.FromLeftWithIncompleteCodon);
    }

    public static int convertAAPositionToNtFromRight(int aaPosition, int ntSequenceLength) {
        return AminoAcidSequence.convertAAPositionToNt(aaPosition, ntSequenceLength, TranslationParameters.FromRightWithIncompleteCodon);
    }

    public static AminoAcidSequencePosition convertNtPositionToAA(int ntPosition, int ntSequenceLength, TranslationParameters translationParameters) {
        if (translationParameters.fromLeft == null) {
            int aaLength = ntSequenceLength / 3;
            int leftAALength = (aaLength + 1) / 2;
            int rightAALength = aaLength - leftAALength;
            int lastLeftNt = ntSequenceLength - rightAALength * 3;
            return ntPosition < lastLeftNt ? AminoAcidSequence.convertNtPositionToAA(ntPosition, ntSequenceLength, TranslationParameters.FromLeftWithIncompleteCodon) : AminoAcidSequence.convertNtPositionToAA(ntPosition, ntSequenceLength, TranslationParameters.FromRightWithIncompleteCodon);
        }
        if (translationParameters.fromLeft.booleanValue()) {
            ntPosition -= translationParameters.frame;
            if (translationParameters.includeIncomplete && translationParameters.frame != 0) {
                ntPosition += 3;
            }
            if (ntPosition < 0) {
                return null;
            }
            int aa = ntPosition / 3;
            if (!translationParameters.includeIncomplete && aa >= ntSequenceLength / 3) {
                return null;
            }
            return new AminoAcidSequencePosition(aa, ntPosition % 3);
        }
        return AminoAcidSequence.convertNtPositionToAA(ntPosition, ntSequenceLength, translationParameters.convertToLeftBound(ntSequenceLength));
    }

    public static AminoAcidSequencePosition convertNtPositionToAAFromRight(int ntPosition, int ntSequenceLength) {
        return AminoAcidSequence.convertNtPositionToAA(ntPosition, ntSequenceLength, TranslationParameters.FromRightWithIncompleteCodon);
    }

    public static AminoAcidSequencePosition convertNtPositionToAAFromLeft(int ntPosition, int ntSequenceLength) {
        return AminoAcidSequence.convertNtPositionToAA(ntPosition, ntSequenceLength, TranslationParameters.FromLeftWithIncompleteCodon);
    }

    public static AminoAcidSequencePosition convertNtPositionToAAFromCenter(int ntPosition, int ntSequenceLength) {
        return AminoAcidSequence.convertNtPositionToAA(ntPosition, ntSequenceLength, TranslationParameters.FromCenter);
    }

    public static AminoAcidSequence translate(NucleotideSequence ns, TranslationParameters translationParameters) {
        byte[] data;
        if (translationParameters.fromLeft == null) {
            data = new byte[(ns.size() + (translationParameters.includeIncomplete ? 2 : 0)) / 3];
            int aaLength = ns.size() / 3;
            int leftAALength = (aaLength + 1) / 2;
            int rightAALength = aaLength - leftAALength;
            GeneticCode.translate(data, 0, ns, 0, leftAALength * 3);
            GeneticCode.translate(data, data.length - rightAALength, ns, ns.size() - rightAALength * 3, rightAALength * 3);
            if (ns.size() % 3 != 0) {
                data[leftAALength] = 21;
            }
        } else if (translationParameters.fromLeft.booleanValue()) {
            int aaLength = (ns.size() - translationParameters.frame + (translationParameters.includeIncomplete ? 2 : 0)) / 3;
            if (translationParameters.includeIncomplete && translationParameters.frame != 0) {
                ++aaLength;
            }
            data = new byte[aaLength];
            int pointer = 0;
            if (translationParameters.includeIncomplete && translationParameters.frame != 0) {
                data[pointer++] = 21;
            }
            int trLength = (ns.size() - translationParameters.frame) / 3 * 3;
            GeneticCode.translate(data, pointer, ns, translationParameters.frame, trLength);
            if ((pointer += trLength / 3) != aaLength) {
                data[data.length - 1] = 21;
            }
        } else {
            return AminoAcidSequence.translate(ns, translationParameters.convertToLeftBound(ns.size()));
        }
        return new AminoAcidSequence(data, true);
    }

    public static AminoAcidSequence translateFromRight(NucleotideSequence ns) {
        return AminoAcidSequence.translate(ns, TranslationParameters.FromRightWithIncompleteCodon);
    }

    public static AminoAcidSequence translateFromLeft(NucleotideSequence ns) {
        return AminoAcidSequence.translate(ns, TranslationParameters.FromLeftWithIncompleteCodon);
    }

    public static AminoAcidSequence translateFromCenter(NucleotideSequence ns) {
        return AminoAcidSequence.translate(ns, TranslationParameters.FromCenter);
    }

    public static final class AminoAcidSequencePosition {
        public final int aminoAcidPosition;
        public final byte positionInTriplet;

        public AminoAcidSequencePosition(int aminoAcidPosition, int positionInTriplet) {
            this.aminoAcidPosition = aminoAcidPosition;
            this.positionInTriplet = (byte)positionInTriplet;
        }

        public int floor() {
            return this.aminoAcidPosition;
        }

        public int ceil() {
            return this.positionInTriplet == 0 ? this.aminoAcidPosition : this.aminoAcidPosition + 1;
        }

        public String toString() {
            return "A" + this.aminoAcidPosition + "+" + this.positionInTriplet + "n";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AminoAcidSequencePosition)) {
                return false;
            }
            AminoAcidSequencePosition that = (AminoAcidSequencePosition)o;
            if (this.aminoAcidPosition != that.aminoAcidPosition) {
                return false;
            }
            return this.positionInTriplet == that.positionInTriplet;
        }

        public int hashCode() {
            int result = this.aminoAcidPosition;
            result = 31 * result + this.positionInTriplet;
            return result;
        }
    }
}

