/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.core.sequence.AbstractSeq;
import com.milaboratory.core.sequence.SeqBuilder;
import java.util.Arrays;

public abstract class ArraySeqBuilder<S extends AbstractSeq<S>, B extends ArraySeqBuilder<S, B>>
implements SeqBuilder<S> {
    byte[] data;
    int size = 0;

    ArraySeqBuilder() {
    }

    ArraySeqBuilder(byte[] data, int size) {
        this.data = data;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void ensureInternalCapacity(int newSize) {
        if (this.size == -1) {
            throw new IllegalStateException("Destroyed.");
        }
        if (this.data == null) {
            if (newSize != 0) {
                this.data = new byte[Math.max(newSize, 10)];
            } else {
                return;
            }
        }
        if (this.data.length < newSize) {
            this.data = Arrays.copyOf(this.data, Math.max(newSize, 3 * this.data.length / 2 + 1));
        }
    }

    public B ensureCapacity(int capacity) {
        if (this.size == -1) {
            throw new IllegalStateException("Destroyed.");
        }
        if (capacity > 0) {
            if (this.data == null) {
                this.data = new byte[capacity];
            } else if (capacity > this.data.length) {
                this.data = Arrays.copyOf(this.data, capacity);
            }
        }
        return (B)this;
    }

    abstract S createUnsafe(byte[] var1);

    abstract byte[] getUnsafe(S var1);

    @Override
    public S createAndDestroy() {
        if (this.data == null) {
            return this.createUnsafe(new byte[0]);
        }
        S seq = this.data.length == this.size ? this.createUnsafe(this.data) : this.createUnsafe(Arrays.copyOf(this.data, this.size));
        this.data = null;
        this.size = -1;
        return seq;
    }

    public B append(byte value) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = value;
        return (B)this;
    }

    public B append(S seq) {
        if (seq.size() == 0) {
            return (B)this;
        }
        this.ensureInternalCapacity(this.size + seq.size());
        System.arraycopy(this.getUnsafe(seq), 0, this.data, this.size, seq.size());
        this.size += seq.size();
        return (B)this;
    }

    public abstract B clone();
}

