/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.core.sequence.AbstractArrayAlphabet;
import com.milaboratory.core.sequence.AbstractArraySequence;
import com.milaboratory.core.sequence.ArraySeqBuilder;
import com.milaboratory.core.sequence.SequenceBuilder;

final class ArraySequenceBuilder<S extends AbstractArraySequence<S>>
extends ArraySeqBuilder<S, ArraySequenceBuilder<S>>
implements SequenceBuilder<S> {
    private final AbstractArrayAlphabet<S> alphabet;

    ArraySequenceBuilder(AbstractArrayAlphabet<S> alphabet) {
        this.alphabet = alphabet;
    }

    ArraySequenceBuilder(byte[] data, int size, AbstractArrayAlphabet<S> alphabet) {
        super(data, size);
        this.alphabet = alphabet;
    }

    @Override
    S createUnsafe(byte[] b) {
        return this.alphabet.createUnsafe(b);
    }

    @Override
    byte[] getUnsafe(S s) {
        return ((AbstractArraySequence)s).data;
    }

    @Override
    public ArraySequenceBuilder<S> set(int position, byte letter) {
        if (position < 0 || position >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[position] = letter;
        return this;
    }

    @Override
    public ArraySequenceBuilder<S> append(byte letter) {
        this.ensureInternalCapacity(this.size + 1);
        this.data[this.size++] = letter;
        return this;
    }

    @Override
    public ArraySequenceBuilder<S> clone() {
        return new ArraySequenceBuilder<S>(this.data == null ? null : (byte[])this.data.clone(), this.size, this.alphabet);
    }

    @Override
    public SequenceBuilder<S> append(byte[] letters) {
        if (letters.length == 0) {
            return this;
        }
        this.ensureInternalCapacity(this.size + letters.length);
        System.arraycopy(letters, 0, this.data, this.size, letters.length);
        this.size += letters.length;
        return this;
    }

    @Override
    public ArraySequenceBuilder<S> ensureCapacity(int capacity) {
        super.ensureCapacity(capacity);
        return this;
    }

    public String toString() {
        return ((AbstractArraySequence)this.clone().createAndDestroy()).toString();
    }
}

