/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.core.sequence.AminoAcidAlphabet;
import com.milaboratory.core.sequence.NucleotideAlphabet;
import com.milaboratory.core.sequence.NucleotideSequence;

public final class GeneticCode {
    private static byte[] code = null;

    public static byte getAminoAcid(int triplet) {
        return code[triplet];
    }

    public static void translate(byte[] dest, int offsetInDest, NucleotideSequence sequence, int offsetInSeq, int seqLength) {
        if (seqLength % 3 != 0) {
            throw new IllegalArgumentException("Only nucleotide sequences with size multiple of three are supported (in-frame).");
        }
        if (sequence.containsWildcards(offsetInSeq, offsetInSeq + seqLength)) {
            throw new IllegalArgumentException("Nucleotide sequences with wildcards are not supported.");
        }
        int size = seqLength / 3;
        for (int i = 0; i < size; ++i) {
            int triplet = sequence.codeAt(offsetInSeq + i * 3) << 4 | sequence.codeAt(offsetInSeq + i * 3 + 1) << 2 | sequence.codeAt(offsetInSeq + i * 3 + 2);
            dest[i + offsetInDest] = code[triplet];
        }
    }

    static {
        char[] Base1 = "ttttttttttttttttccccccccccccccccaaaaaaaaaaaaaaaagggggggggggggggg".toCharArray();
        char[] Base2 = "ttttccccaaaaggggttttccccaaaaggggttttccccaaaaggggttttccccaaaagggg".toCharArray();
        char[] Base3 = "tcagtcagtcagtcagtcagtcagtcagtcagtcagtcagtcagtcagtcagtcagtcagtcag".toCharArray();
        char[] Amino = "FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG".toCharArray();
        code = new byte[Base1.length];
        for (int i = 0; i < Base1.length; ++i) {
            byte b0 = NucleotideAlphabet.INSTANCE.symbolToCode(Base1[i]);
            byte b1 = NucleotideAlphabet.INSTANCE.symbolToCode(Base2[i]);
            byte b2 = NucleotideAlphabet.INSTANCE.symbolToCode(Base3[i]);
            int triplet = b0 << 4 | b1 << 2 | b2;
            GeneticCode.code[triplet] = AminoAcidAlphabet.INSTANCE.symbolToCode(Amino[i]);
        }
    }
}

