/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Alphabets;
import com.milaboratory.core.sequence.AminoAcidSequence;
import com.milaboratory.core.sequence.NSequenceWithQuality;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.primitivio.PrimitivI;
import com.milaboratory.primitivio.PrimitivO;
import com.milaboratory.primitivio.Serializer;
import java.io.IOException;

final class IO {
    private IO() {
    }

    public static final class SQSeqDeserializer
    extends JsonDeserializer<SequenceQuality> {
        public SequenceQuality deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new SequenceQuality((String)jp.readValueAs(String.class));
        }
    }

    public static final class SQSeqSerializer
    extends JsonSerializer<SequenceQuality> {
        public void serialize(SequenceQuality value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }

    public static final class AASeqDeserializer
    extends JsonDeserializer<AminoAcidSequence> {
        public AminoAcidSequence deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new AminoAcidSequence((String)jp.readValueAs(String.class));
        }
    }

    public static final class AASeqSerializer
    extends JsonSerializer<AminoAcidSequence> {
        public void serialize(AminoAcidSequence value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }

    public static final class NSeqDeserializer
    extends JsonDeserializer<NucleotideSequence> {
        public NucleotideSequence deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new NucleotideSequence((String)jp.readValueAs(String.class));
        }
    }

    public static final class NSeqSerializer
    extends JsonSerializer<NucleotideSequence> {
        public void serialize(NucleotideSequence value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }

    public static class NSequenceWithQualitySerializer
    implements Serializer<NSequenceWithQuality> {
        @Override
        public void write(PrimitivO output, NSequenceWithQuality object) {
            output.writeObject(object.sequence);
            output.writeObject(object.quality);
        }

        @Override
        public NSequenceWithQuality read(PrimitivI input) {
            NucleotideSequence seq = input.readObject(NucleotideSequence.class);
            SequenceQuality qual = input.readObject(SequenceQuality.class);
            return new NSequenceWithQuality(seq, qual);
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    public static class SequenceQualitySerializer
    implements Serializer<SequenceQuality> {
        @Override
        public void write(PrimitivO output, SequenceQuality object) {
            output.writeObject(object.data);
        }

        @Override
        public SequenceQuality read(PrimitivI input) {
            return new SequenceQuality(input.readObject(byte[].class));
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    public static class SequenceSerializer
    implements Serializer<Sequence> {
        @Override
        public void write(PrimitivO output, Sequence object) {
            output.writeObject(object.getAlphabet());
            output.writeObject(object.asArray());
        }

        @Override
        public Sequence read(PrimitivI input) {
            Alphabet alphabet = input.readObject(Alphabet.class);
            return alphabet.createBuilder().append(input.readObject(byte[].class)).createAndDestroy();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }

    public static class AlphabetSerializer
    implements Serializer<Alphabet> {
        @Override
        public void write(PrimitivO output, Alphabet object) {
            output.writeByte(object.getId());
        }

        @Override
        public Alphabet read(PrimitivI input) {
            return Alphabets.getById(input.readByte());
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public boolean handlesReference() {
            return false;
        }
    }
}

