/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.milaboratory.core.Range;
import com.milaboratory.core.sequence.IO;
import com.milaboratory.core.sequence.MultiNSequenceWithQuality;
import com.milaboratory.core.sequence.NSeq;
import com.milaboratory.core.sequence.NSequenceWithQualityBuilder;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.core.sequence.SequenceWithQuality;
import com.milaboratory.primitivio.annotations.Serializable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
@Serializable(by=IO.NSequenceWithQualitySerializer.class)
public final class NSequenceWithQuality
extends SequenceWithQuality<NucleotideSequence>
implements NSeq<NSequenceWithQuality>,
MultiNSequenceWithQuality {
    public static final NSequenceWithQuality EMPTY = new NSequenceWithQuality(NucleotideSequence.EMPTY, SequenceQuality.EMPTY);

    @JsonCreator
    public NSequenceWithQuality(@JsonProperty(value="sequence") NucleotideSequence sequence, @JsonProperty(value="quality") SequenceQuality quality) {
        super(sequence, quality);
    }

    public NSequenceWithQuality(String sequence, String quality) {
        super(new NucleotideSequence(sequence), new SequenceQuality(quality));
    }

    public NSequenceWithQuality(String sequence) {
        this(new NucleotideSequence(sequence));
    }

    public NSequenceWithQuality(NucleotideSequence sequence, byte quality) {
        super(sequence, SequenceQuality.getUniformQuality(quality, sequence.size()));
    }

    public NSequenceWithQuality(NucleotideSequence sequence) {
        this(sequence, 34);
    }

    @Override
    public NSequenceWithQuality getReverseComplement() {
        return new NSequenceWithQuality(((NucleotideSequence)this.sequence).getReverseComplement(), this.quality.reverse());
    }

    @Override
    public int numberOfSequences() {
        return 1;
    }

    @Override
    public NSequenceWithQuality get(int id) {
        if (id != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public NSequenceWithQuality getRange(int from, int to) {
        return new NSequenceWithQuality((NucleotideSequence)((NucleotideSequence)this.sequence).getRange(from, to), this.quality.getRange(from, to));
    }

    @Override
    public NSequenceWithQuality getRange(Range range) {
        return new NSequenceWithQuality(((NucleotideSequence)this.sequence).getRange(range), this.quality.getRange(range));
    }

    public NSequenceWithQualityBuilder getBuilder() {
        return new NSequenceWithQualityBuilder();
    }

    @Override
    public NSequenceWithQuality concatenate(NSequenceWithQuality other) {
        return this.getBuilder().ensureCapacity(other.size() + this.size()).append(this).append(other).createAndDestroy();
    }
}

