/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.core.sequence.AbstractArrayAlphabet;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Wildcard;

public final class NucleotideAlphabet
extends AbstractArrayAlphabet<NucleotideSequence> {
    public static final byte A = 0;
    public static final byte G = 1;
    public static final byte C = 2;
    public static final byte T = 3;
    public static final byte N = 4;
    public static final byte R = 5;
    public static final byte Y = 6;
    public static final byte S = 7;
    public static final byte W = 8;
    public static final byte K = 9;
    public static final byte M = 10;
    public static final byte B = 11;
    public static final byte D = 12;
    public static final byte H = 13;
    public static final byte V = 14;
    public static final Wildcard A_WILDCARD = new Wildcard('A', 0, 1, new byte[]{0, 4, 5, 8, 10, 12, 13, 14});
    public static final Wildcard G_WILDCARD = new Wildcard('G', 1, 1, new byte[]{1, 4, 5, 7, 9, 11, 12, 14});
    public static final Wildcard C_WILDCARD = new Wildcard('C', 2, 1, new byte[]{2, 4, 6, 7, 10, 11, 13, 14});
    public static final Wildcard T_WILDCARD = new Wildcard('T', 3, 1, new byte[]{3, 4, 6, 8, 9, 11, 12, 13});
    public static final Wildcard N_WILDCARD = new Wildcard('N', 4, 4, new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14});
    public static final Wildcard R_WILDCARD = new Wildcard('R', 5, 2, new byte[]{0, 1, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14});
    public static final Wildcard Y_WILDCARD = new Wildcard('Y', 6, 2, new byte[]{2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14});
    public static final Wildcard S_WILDCARD = new Wildcard('S', 7, 2, new byte[]{1, 2, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14});
    public static final Wildcard W_WILDCARD = new Wildcard('W', 8, 2, new byte[]{0, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14});
    public static final Wildcard K_WILDCARD = new Wildcard('K', 9, 2, new byte[]{1, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14});
    public static final Wildcard M_WILDCARD = new Wildcard('M', 10, 2, new byte[]{0, 2, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14});
    public static final Wildcard B_WILDCARD = new Wildcard('B', 11, 3, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14});
    public static final Wildcard D_WILDCARD = new Wildcard('D', 12, 3, new byte[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14});
    public static final Wildcard H_WILDCARD = new Wildcard('H', 13, 3, new byte[]{0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14});
    public static final Wildcard V_WILDCARD = new Wildcard('V', 14, 3, new byte[]{0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14});
    private static final Wildcard[] WILDCARDS;
    private static final byte[] COMPLEMENT_CODE;
    private static final Wildcard[] COMPLEMENT_WILDCARD;
    static final NucleotideAlphabet INSTANCE;

    private NucleotideAlphabet() {
        super("nucleotide", (byte)1, 4, N_WILDCARD, A_WILDCARD, T_WILDCARD, G_WILDCARD, C_WILDCARD, N_WILDCARD, R_WILDCARD, Y_WILDCARD, S_WILDCARD, W_WILDCARD, K_WILDCARD, M_WILDCARD, B_WILDCARD, D_WILDCARD, H_WILDCARD, V_WILDCARD);
    }

    public static byte complementCode(byte code) {
        return COMPLEMENT_CODE[code];
    }

    public static byte complementCode(Wildcard wildcard) {
        return COMPLEMENT_CODE[wildcard.code];
    }

    public static Wildcard complementWildcard(byte code) {
        return COMPLEMENT_WILDCARD[code];
    }

    public static Wildcard complementWildcard(Wildcard wildcard) {
        return COMPLEMENT_WILDCARD[wildcard.code];
    }

    public static byte symbolByteFromCode(byte code) {
        return (byte)INSTANCE.codeToSymbol(code);
    }

    public static byte byteSymbolToCode(byte symbol) {
        return INSTANCE.symbolToCode((char)symbol);
    }

    @Override
    NucleotideSequence createUnsafe(byte[] array) {
        return new NucleotideSequence(array, true);
    }

    private static byte getComplement1(byte nucleotide) {
        return (byte)(nucleotide ^ 3);
    }

    private static long getComplementMask(Wildcard wildcard) {
        long basic = 0L;
        for (int i = 0; i < wildcard.basicSize(); ++i) {
            basic |= (long)(1 << NucleotideAlphabet.getComplement1(wildcard.matchingCodes[i]));
        }
        return basic;
    }

    static {
        INSTANCE = new NucleotideAlphabet();
        WILDCARDS = INSTANCE.getAllWildcards().toArray(new Wildcard[INSTANCE.size()]);
        COMPLEMENT_CODE = new byte[WILDCARDS.length];
        COMPLEMENT_WILDCARD = new Wildcard[WILDCARDS.length];
        for (int i = 0; i < WILDCARDS.length; ++i) {
            Wildcard complementWildcard;
            NucleotideAlphabet.COMPLEMENT_WILDCARD[i] = complementWildcard = INSTANCE.maskToWildcard(NucleotideAlphabet.getComplementMask(WILDCARDS[i]));
            NucleotideAlphabet.COMPLEMENT_CODE[i] = complementWildcard.code;
        }
    }
}

