/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.milaboratory.core.Range;
import com.milaboratory.core.sequence.AbstractArraySequence;
import com.milaboratory.core.sequence.IO;
import com.milaboratory.core.sequence.NSeq;
import com.milaboratory.core.sequence.NucleotideAlphabet;
import java.io.Serializable;

@JsonSerialize(using=IO.NSeqSerializer.class)
@JsonDeserialize(using=IO.NSeqDeserializer.class)
public final class NucleotideSequence
extends AbstractArraySequence<NucleotideSequence>
implements NSeq<NucleotideSequence>,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final NucleotideAlphabet ALPHABET = NucleotideAlphabet.INSTANCE;
    public static final NucleotideSequence EMPTY = new NucleotideSequence("");

    public NucleotideSequence(String sequence) {
        super(sequence);
    }

    public NucleotideSequence(char[] sequence) {
        super(sequence);
    }

    public NucleotideSequence(byte[] data) {
        super((byte[])data.clone());
    }

    NucleotideSequence(byte[] data, boolean unsafe) {
        super(data);
        assert (unsafe);
    }

    @Override
    public NucleotideSequence getRange(Range range) {
        if (range.getLower() < 0 || range.getUpper() < 0 || range.getLower() > this.size() || range.getUpper() > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (range.length() == 0) {
            return EMPTY;
        }
        if (range.isReverse()) {
            return new NucleotideSequence(NucleotideSequence.transformToRC(this.data, range.getLower(), range.getUpper()), true);
        }
        return (NucleotideSequence)super.getRange(range);
    }

    @Override
    public NucleotideSequence getReverseComplement() {
        return new NucleotideSequence(NucleotideSequence.transformToRC(this.data, 0, this.data.length), true);
    }

    public boolean containsWildcards(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (!NucleotideSequence.isWildcard(this.codeAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean containsWildcards() {
        return this.containsWildcards(0, this.size());
    }

    @Override
    public NucleotideAlphabet getAlphabet() {
        return ALPHABET;
    }

    public static NucleotideSequence fromSequence(byte[] sequence, int offset, int length) {
        byte[] storage = new byte[length];
        for (int i = 0; i < length; ++i) {
            storage[i] = ALPHABET.symbolToCode((char)sequence[offset + i]);
        }
        return new NucleotideSequence(storage, true);
    }

    private static byte[] transformToRC(byte[] data, int from, int to) {
        byte[] newData = new byte[to - from];
        int s = to - from;
        for (int coord = 0; coord < s; ++coord) {
            int reverseCord = to - 1 - coord;
            newData[coord] = NucleotideAlphabet.complementCode(data[reverseCord]);
        }
        return newData;
    }

    private static boolean isWildcard(byte nucleotide) {
        return nucleotide >= 4;
    }
}

