/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.core.alignment.batch.HasSequence;
import com.milaboratory.core.motif.Motif;
import com.milaboratory.core.sequence.AbstractSeq;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.IO;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.primitivio.annotations.Serializable;

@Serializable(by=IO.SequenceSerializer.class)
public abstract class Sequence<S extends Sequence<S>>
extends AbstractSeq<S>
implements Comparable<S>,
HasSequence<S> {
    public abstract byte codeAt(int var1);

    public abstract Alphabet<S> getAlphabet();

    public byte[] asArray() {
        byte[] bytes = new byte[this.size()];
        for (int i = this.size() - 1; i >= 0; --i) {
            bytes[i] = this.codeAt(i);
        }
        return bytes;
    }

    public char symbolAt(int position) {
        return this.getAlphabet().codeToSymbol(this.codeAt(position));
    }

    public Motif<S> toMotif() {
        return new Motif<Sequence>(this);
    }

    public boolean containWildcards() {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getAlphabet().isWildcard(this.codeAt(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public S getSequence() {
        return (S)this;
    }

    @Override
    public SequenceBuilder<S> getBuilder() {
        return this.getAlphabet().createBuilder();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)obj;
        if (other.getAlphabet() != this.getAlphabet()) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if (other.codeAt(i) == this.codeAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash += 31 * this.getAlphabet().hashCode();
        for (int i = this.size() - 1; i >= 0; --i) {
            hash = hash * 7 + this.codeAt(i);
        }
        return hash;
    }

    public String toString() {
        char[] chars = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            chars[i] = this.getAlphabet().codeToSymbol(this.codeAt(i));
        }
        return new String(chars);
    }

    @Override
    public int compareTo(S o) {
        if (this.getAlphabet() != ((Sequence)o).getAlphabet()) {
            throw new RuntimeException();
        }
        if (this.size() != o.size()) {
            if (this.size() < o.size()) {
                return -1;
            }
            return 1;
        }
        for (int i = 0; i < this.size(); ++i) {
            byte b1;
            byte b0 = this.codeAt(i);
            if (b0 == (b1 = ((Sequence)o).codeAt(i))) continue;
            if (b0 < b1) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public int indexOf(S subSequence) {
        if (subSequence.size() == 0) {
            return -1;
        }
        int limit = this.size() - subSequence.size();
        block0: for (int i = 0; i <= limit; ++i) {
            for (int j = 0; j < subSequence.size(); ++j) {
                if (((Sequence)subSequence).codeAt(j) != this.codeAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }
}

