/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.milaboratory.core.Range;
import com.milaboratory.core.io.sequence.fastq.QualityFormat;
import com.milaboratory.core.io.sequence.fastq.WrongQualityFormat;
import com.milaboratory.core.sequence.AbstractSeq;
import com.milaboratory.core.sequence.IO;
import com.milaboratory.core.sequence.SequenceQualityBuilder;
import com.milaboratory.primitivio.annotations.Serializable;
import com.milaboratory.util.ArraysUtils;
import java.util.Arrays;

@JsonSerialize(using=IO.SQSeqSerializer.class)
@JsonDeserialize(using=IO.SQSeqDeserializer.class)
@Serializable(by=IO.SequenceQualitySerializer.class)
public final class SequenceQuality
extends AbstractSeq<SequenceQuality>
implements java.io.Serializable {
    public static final SequenceQuality EMPTY = new SequenceQuality(new byte[0]);
    public static final byte GOOD_QUALITY_VALUE = 34;
    public static final byte MAX_QUALITY_VALUE = 58;
    public static final byte BAD_QUALITY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    final byte[] data;

    public SequenceQuality(String string) {
        this(string, 33);
    }

    public SequenceQuality(String string, int offset) {
        this.data = string.getBytes();
        int i = this.data.length - 1;
        while (i >= 0) {
            int n = i--;
            this.data[n] = (byte)(this.data[n] - offset);
        }
    }

    public SequenceQuality(String string, QualityFormat format) {
        this(string, format.getOffset());
    }

    public SequenceQuality(byte[] data) {
        this.data = (byte[])data.clone();
    }

    SequenceQuality(byte[] data, boolean unsafe) {
        assert (unsafe);
        this.data = data;
    }

    public byte[] asArray() {
        return (byte[])this.data.clone();
    }

    public float log10ProbabilityOfErrorAt(int position) {
        return -((float)this.data[position]) / 10.0f;
    }

    public float probabilityOfErrorAt(int position) {
        return (float)Math.pow(10.0, -this.data[position] / 10);
    }

    public byte value(int position) {
        return this.data[position];
    }

    public byte minValue() {
        if (this.data.length == 0) {
            return 0;
        }
        byte min = 127;
        for (byte b : this.data) {
            if (b >= min) continue;
            min = b;
        }
        return min;
    }

    public byte meanValue() {
        if (this.data.length == 0) {
            return 0;
        }
        int sum = 0;
        for (byte b : this.data) {
            sum += b;
        }
        return (byte)(sum / this.data.length);
    }

    public SequenceQuality reverse() {
        return new SequenceQuality(SequenceQuality.reverseCopy(this.data), true);
    }

    @Override
    public SequenceQuality getRange(int from, int to) {
        return this.getRange(new Range(from, to));
    }

    @Override
    public SequenceQuality getRange(Range range) {
        byte[] rdata = Arrays.copyOfRange(this.data, range.getLower(), range.getUpper());
        if (range.isReverse()) {
            ArraysUtils.reverse(rdata);
        }
        return new SequenceQuality(rdata, true);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    public SequenceQualityBuilder getBuilder() {
        return new SequenceQualityBuilder();
    }

    @Override
    public SequenceQuality concatenate(SequenceQuality ... other) {
        if (other.length == 0) {
            return this;
        }
        int size = this.size();
        for (SequenceQuality sequenceQuality : other) {
            size += sequenceQuality.size();
        }
        byte[] r = Arrays.copyOf(this.data, size);
        size = this.size();
        for (SequenceQuality sq : other) {
            System.arraycopy(sq.data, 0, r, size, sq.size());
            size += sq.size();
        }
        return new SequenceQuality(r, true);
    }

    public void encodeTo(QualityFormat format, byte[] buffer, int offset) {
        byte vo = format.getOffset();
        for (int i = 0; i < this.data.length; ++i) {
            buffer[offset++] = (byte)(this.data[i] + vo);
        }
    }

    public byte[] encode(int offset) {
        if (offset < 0 || offset > 70) {
            throw new IllegalArgumentException();
        }
        byte[] copy = new byte[this.data.length];
        for (int i = copy.length - 1; i >= 0; --i) {
            int n = i;
            copy[n] = (byte)(copy[n] + (this.data[i] + offset));
        }
        return copy;
    }

    public byte[] encode(QualityFormat format) {
        return this.encode(format.getOffset());
    }

    public String encodeToString(int offset) {
        return new String(this.encode(offset));
    }

    public int hashCode() {
        return Arrays.hashCode(this.data) * 31 + 17;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceQuality that = (SequenceQuality)o;
        return Arrays.equals(this.data, that.data);
    }

    public String toString() {
        return this.encodeToString(33);
    }

    public static SequenceQuality getUniformQuality(byte qualityValue, int length) {
        byte[] data = new byte[length];
        Arrays.fill(data, qualityValue);
        return new SequenceQuality(data, true);
    }

    private static byte[] reverseCopy(byte[] quality) {
        byte[] newData = new byte[quality.length];
        int reverseposition = quality.length - 1;
        int position = 0;
        while (position < quality.length) {
            newData[position] = quality[reverseposition];
            ++position;
            --reverseposition;
        }
        assert (reverseposition == -1);
        return newData;
    }

    public static SequenceQuality create(QualityFormat format, byte[] data, int from, int length, boolean check) {
        if (from + length >= data.length || from < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        byte valueOffset = format.getOffset();
        byte minValue = format.getMinValue();
        byte maxValue = format.getMaxValue();
        byte[] res = new byte[length];
        int pointer = from;
        for (int i = 0; i < length; ++i) {
            res[i] = (byte)(data[pointer++] - valueOffset);
            if (!check || res[i] >= minValue && res[i] <= maxValue) continue;
            throw new WrongQualityFormat((char)data[i] + " [" + res[i] + "]");
        }
        return new SequenceQuality(res, true);
    }

    public static SequenceQuality create(QualityFormat format, byte[] data, boolean check) {
        return SequenceQuality.create(format, data, 0, data.length, check);
    }
}

