/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.core.Range;
import com.milaboratory.core.sequence.AbstractSeq;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceQuality;
import java.io.Serializable;

public class SequenceWithQuality<S extends Sequence<S>>
implements Serializable {
    final S sequence;
    final SequenceQuality quality;

    public SequenceWithQuality(S sequence, SequenceQuality quality) {
        if (sequence.size() != quality.size()) {
            throw new IllegalArgumentException("Different sizes.");
        }
        this.sequence = sequence;
        this.quality = quality;
    }

    public S getSequence() {
        return this.sequence;
    }

    public SequenceQuality getQuality() {
        return this.quality;
    }

    public SequenceWithQuality<S> getSubSequence(int from, int to) {
        return this.getSubSequence(new Range(from, to));
    }

    public SequenceWithQuality<S> getSubSequence(Range range) {
        return new SequenceWithQuality<Sequence>((Sequence)((AbstractSeq)this.sequence).getRange(range), this.quality.getRange(range));
    }

    public int size() {
        return this.sequence.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceWithQuality that = (SequenceWithQuality)o;
        return ((Sequence)this.sequence).equals(that.sequence) && this.quality.equals(that.quality);
    }

    public int hashCode() {
        int result = ((Sequence)this.sequence).hashCode();
        result = 31 * result + this.quality.hashCode();
        return result;
    }

    public String toPrettyString() {
        String seq = ((Sequence)this.sequence).toString();
        String qual = this.quality.toString();
        return seq + '\n' + qual;
    }

    public String toString() {
        return ((Sequence)this.sequence).toString() + " " + this.quality.toString();
    }
}

