/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Alphabets;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Seq;
import com.milaboratory.core.sequence.SeqBuilder;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.util.Bit2Array;
import com.milaboratory.util.HashFunctions;
import java.util.HashSet;
import java.util.Set;

public final class SequencesUtils {
    public static boolean belongsToAlphabet(Alphabet<?> alphabet, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (alphabet.symbolToCode(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static Set<Alphabet<?>> possibleAlphabets(String string) {
        HashSet alphabets = new HashSet();
        for (Alphabet alphabet : Alphabets.getAll()) {
            if (!SequencesUtils.belongsToAlphabet(alphabet, string)) continue;
            alphabets.add(alphabet);
        }
        return alphabets;
    }

    public static <S extends Sequence<S>> int mismatchCount(S seq0, int seq0Offset, S seq1, int seq1Offset, int length) {
        if (seq0.size() < seq0Offset + length || seq1.size() < seq1Offset + length) {
            throw new IllegalArgumentException();
        }
        int mm = 0;
        for (int i = 0; i < length; ++i) {
            if (seq0.codeAt(i + seq0Offset) == seq1.codeAt(i + seq1Offset)) continue;
            ++mm;
        }
        return mm;
    }

    public static <S extends Seq<S>> S concatenate(S ... sequences) {
        if (sequences.length == 0) {
            throw new IllegalArgumentException("Zero arguments");
        }
        if (sequences.length == 1) {
            return sequences[0];
        }
        int size = 0;
        for (S s : sequences) {
            size += s.size();
        }
        SeqBuilder<S> builder = sequences[0].getBuilder().ensureCapacity(size);
        for (S s : sequences) {
            builder.append(s);
        }
        return builder.createAndDestroy();
    }

    public static <S extends Sequence<S>> S wildcardsToRandomBasic(S sequence, long seed) {
        Alphabet<S> alphabet = sequence.getAlphabet();
        SequenceBuilder<byte> sequenceBuilder = alphabet.createBuilder().ensureCapacity(sequence.size());
        for (int i = 0; i < sequence.size(); ++i) {
            byte code = sequence.codeAt(i);
            if (alphabet.isWildcard(code)) {
                seed = HashFunctions.JenkinWang64shift(seed + (long)i);
                sequenceBuilder.append(alphabet.codeToWildcard(code).getUniformlyDistributedBasicCode(seed));
                continue;
            }
            sequenceBuilder.append(code);
        }
        return sequenceBuilder.createAndDestroy();
    }

    public static Bit2Array convertNSequenceToBit2Array(NucleotideSequence seq) {
        if (seq.containWildcards()) {
            throw new IllegalArgumentException("Sequences with wildcards are not supported.");
        }
        Bit2Array bar = new Bit2Array(seq.size());
        for (int i = 0; i < seq.size(); ++i) {
            bar.set(i, seq.codeAt(i));
        }
        return bar;
    }

    public static NucleotideSequence convertBit2ArrayToNSequence(Bit2Array bar) {
        SequenceBuilder<byte> seq = NucleotideSequence.ALPHABET.createBuilder().ensureCapacity(bar.size());
        for (int i = 0; i < bar.size(); ++i) {
            seq.append((byte)bar.get(i));
        }
        return (NucleotideSequence)seq.createAndDestroy();
    }
}

