/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class TranslationParameters {
    public static final TranslationParameters FromCenter = new TranslationParameters(0, null, true);
    public static final TranslationParameters FromLeftWithIncompleteCodon = new TranslationParameters(0, Boolean.TRUE, true);
    public static final TranslationParameters FromLeftWithoutIncompleteCodon = new TranslationParameters(0, Boolean.TRUE, false);
    public static final TranslationParameters FromRightWithIncompleteCodon = new TranslationParameters(0, Boolean.FALSE, true);
    public static final TranslationParameters FromRightWithoutIncompleteCodon = new TranslationParameters(0, Boolean.FALSE, false);
    final byte frame;
    final Boolean fromLeft;
    final boolean includeIncomplete;
    private static final TranslationParameters Frame1W = new TranslationParameters(1, Boolean.TRUE, true);
    private static final TranslationParameters Frame2W = new TranslationParameters(2, Boolean.TRUE, true);
    private static final TranslationParameters Frame1WO = new TranslationParameters(1, Boolean.TRUE, false);
    private static final TranslationParameters Frame2WO = new TranslationParameters(2, Boolean.TRUE, false);
    private static final Map<TranslationParameters, String> shortNames = new HashMap<TranslationParameters, String>();
    private static final Collection<TranslationParameters> preDefinedParameters;

    private TranslationParameters(byte frame, Boolean fromLeft, boolean includeIncomplete) {
        this.frame = frame;
        this.fromLeft = fromLeft;
        this.includeIncomplete = includeIncomplete;
    }

    public byte getFrame() {
        return this.frame;
    }

    public Boolean getFromLeft() {
        return this.fromLeft;
    }

    public boolean isIncludeIncomplete() {
        return this.includeIncomplete;
    }

    TranslationParameters convertToLeftBound(int ntSequenceLength) {
        if (this.fromLeft == null) {
            throw new IllegalArgumentException();
        }
        if (this.fromLeft.booleanValue()) {
            return this;
        }
        int fr = ntSequenceLength % 3;
        if (this.includeIncomplete) {
            switch (fr) {
                case 0: {
                    return FromLeftWithIncompleteCodon;
                }
                case 1: {
                    return Frame1W;
                }
                case 2: {
                    return Frame2W;
                }
            }
        } else {
            switch (fr) {
                case 0: {
                    return FromLeftWithoutIncompleteCodon;
                }
                case 1: {
                    return Frame1WO;
                }
                case 2: {
                    return Frame2WO;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static TranslationParameters withIncompleteCodon(int inFramePosition) {
        byte frame = (byte)(inFramePosition % 3);
        switch (frame) {
            case 0: {
                return FromLeftWithIncompleteCodon;
            }
            case 1: {
                return Frame1W;
            }
            case 2: {
                return Frame2W;
            }
        }
        throw new IllegalArgumentException();
    }

    public static TranslationParameters withoutIncompleteCodon(int inFramePosition) {
        byte frame = (byte)(inFramePosition % 3);
        switch (frame) {
            case 0: {
                return FromLeftWithoutIncompleteCodon;
            }
            case 1: {
                return Frame1WO;
            }
            case 2: {
                return Frame2WO;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslationParameters that = (TranslationParameters)o;
        if (this.frame != that.frame) {
            return false;
        }
        if (this.includeIncomplete != that.includeIncomplete) {
            return false;
        }
        return !(this.fromLeft == null ? that.fromLeft != null : !this.fromLeft.equals(that.fromLeft));
    }

    public int hashCode() {
        int result = this.frame;
        result = 31 * result + (this.fromLeft != null ? this.fromLeft.hashCode() : 0);
        result = 31 * result + (this.includeIncomplete ? 1 : 0);
        return result;
    }

    public String toString() {
        String shortName = shortNames.get(this);
        if (shortName != null) {
            return shortName;
        }
        return "Frame" + this.frame + (this.includeIncomplete ? "WithIncomplete" : "WithoutIncomplete");
    }

    public static Collection<TranslationParameters> getPreDefinedParameters() {
        return preDefinedParameters;
    }

    static {
        shortNames.put(FromCenter, "FromCenter");
        shortNames.put(FromLeftWithIncompleteCodon, "FromLeftWithIncompleteCodon");
        shortNames.put(FromLeftWithoutIncompleteCodon, "FromLeftWithoutIncompleteCodon");
        shortNames.put(FromRightWithIncompleteCodon, "FromRightWithIncompleteCodon");
        shortNames.put(FromRightWithoutIncompleteCodon, "FromRightWithoutIncompleteCodon");
        preDefinedParameters = Collections.unmodifiableCollection(shortNames.keySet());
    }
}

