/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.core.sequence.NSequenceWithQuality;
import com.milaboratory.core.sequence.NucleotideAlphabet;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.core.sequence.SequenceQualityBuilder;
import com.milaboratory.util.HashFunctions;

public final class UnsafeFactory {
    private UnsafeFactory() {
    }

    public static NSequenceWithQuality fastqParse(byte[] buffer, int fromSequence, int fromQuality, int length, byte qualityValueOffset, long id, boolean replaceWildcards) {
        long seed = id;
        SequenceBuilder<byte> sequence = NucleotideSequence.ALPHABET.createBuilder().ensureCapacity(length);
        SequenceQualityBuilder quality = (SequenceQualityBuilder)new SequenceQualityBuilder().ensureCapacity(length);
        int pointerSeq = fromSequence;
        int pointerQua = fromQuality;
        for (int i = 0; i < length; ++i) {
            byte code;
            byte qual = (byte)(buffer[pointerQua++] - qualityValueOffset);
            if ((code = NucleotideAlphabet.byteSymbolToCode(buffer[pointerSeq++])) == -1) {
                if (buffer[pointerSeq - 1] == 46) {
                    code = 4;
                } else {
                    throw new IllegalArgumentException("Unknown letter \"" + buffer[pointerSeq - 1] + "\"" + (buffer[pointerSeq - 1] == 13 ? ". FASTQ reader does not support Windows-style line breaks (CR+LF), please convert file to standard FASTQ (with Unix-like LF line breaks)." : ""));
                }
            }
            if (replaceWildcards && NucleotideSequence.ALPHABET.isWildcard(code)) {
                seed = HashFunctions.JenkinWang64shift(seed + (long)i);
                code = NucleotideSequence.ALPHABET.codeToWildcard(code).getUniformlyDistributedBasicCode(seed);
                qual = 0;
            }
            sequence.append(code);
            quality.append(qual);
        }
        return new NSequenceWithQuality((NucleotideSequence)sequence.createAndDestroy(), (SequenceQuality)quality.createAndDestroy());
    }
}

