/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence;

import com.milaboratory.util.HashFunctions;
import java.util.Arrays;

public final class Wildcard {
    final char cSymbol;
    final byte bSymbol;
    final byte basicSize;
    final byte[] matchingCodes;
    final byte code;
    final long basicMask;
    final long mask;

    Wildcard(char cSymbol, byte code) {
        this(cSymbol, code, 1, new byte[]{code});
    }

    Wildcard(char cSymbol, byte code, int numberOfBasicCodes, byte[] matchingCodes) {
        if (matchingCodes.length == 0 || Character.isLowerCase(cSymbol)) {
            throw new IllegalArgumentException();
        }
        this.cSymbol = Character.toUpperCase(cSymbol);
        this.bSymbol = (byte)cSymbol;
        this.code = code;
        this.matchingCodes = (byte[])matchingCodes.clone();
        this.basicSize = (byte)numberOfBasicCodes;
        Arrays.sort(this.matchingCodes);
        if (matchingCodes.length == 1 && code != matchingCodes[0]) {
            throw new IllegalArgumentException();
        }
        long basicMask = 0L;
        long mask = 0L;
        for (int i = 0; i < matchingCodes.length; ++i) {
            byte c = matchingCodes[i];
            if (c >= 64) {
                throw new IllegalArgumentException("Don't allow matching codes greater then 63.");
            }
            if (i < numberOfBasicCodes) {
                basicMask |= (long)(1 << c);
            }
            mask |= (long)(1 << c);
        }
        this.basicMask = basicMask;
        this.mask = mask;
    }

    public char getSymbol() {
        return this.cSymbol;
    }

    public long getBasicMask() {
        return this.basicMask;
    }

    public int basicSize() {
        return this.basicSize;
    }

    public int size() {
        return this.matchingCodes.length;
    }

    public boolean isBasic() {
        return this.basicSize == 1;
    }

    public byte getMatchingCode(int i) {
        return this.matchingCodes[i];
    }

    public byte getCode() {
        return this.code;
    }

    public boolean matches(byte code) {
        return (this.mask & (long)(1 << code)) != 0L;
    }

    public boolean intersectsWith(Wildcard otherWildcard) {
        return (this.basicMask & otherWildcard.basicMask) != 0L;
    }

    public byte getUniformlyDistributedBasicCode(long seed) {
        if (this.isBasic()) {
            return this.code;
        }
        if ((seed = HashFunctions.JenkinWang64shift(seed)) < 0L) {
            seed = -seed;
        }
        return this.matchingCodes[(int)(seed % (long)this.basicSize)];
    }
}

