/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence.provider;

import com.milaboratory.core.Range;
import com.milaboratory.core.sequence.Alphabet;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.SequenceBuilder;
import com.milaboratory.core.sequence.provider.SequenceProvider;
import com.milaboratory.core.sequence.provider.SequenceProviderUtils;
import com.milaboratory.util.RangeMap;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CachedSequenceProvider<S extends Sequence<S>>
implements SequenceProvider<S> {
    final Alphabet<S> alphabet;
    final RangeMap<S> sequences = new RangeMap();
    final SequenceProvider<S> provider;

    public CachedSequenceProvider(Alphabet<S> alphabet, SequenceProvider<S> provider) {
        this.alphabet = alphabet;
        this.provider = provider;
    }

    public CachedSequenceProvider(Alphabet<S> alphabet, String missingErrorMessage) {
        this(alphabet, new NoProvider(-1, missingErrorMessage));
    }

    public CachedSequenceProvider(Alphabet<S> alphabet, int size, String missingErrorMessage) {
        this(alphabet, new NoProvider(size, missingErrorMessage));
    }

    public CachedSequenceProvider(Alphabet<S> alphabet, int size) {
        this(alphabet, new NoProvider(size));
    }

    public CachedSequenceProvider(Alphabet<S> alphabet) {
        this(alphabet, new NoProvider(-1));
    }

    public Map.Entry<Range, S> ensureEntry(Range range) {
        if (range.isReverse()) {
            throw new IllegalArgumentException("Don't support inverse ranges");
        }
        Range direct = range.isReverse() ? range.inverse() : range;
        Map.Entry<Range, S> entry = this.sequences.findContaining(direct);
        if (entry != null) {
            return entry;
        }
        List<Map.Entry<Range, S>> allIntersecting = this.sequences.findAllIntersectingOrTouching(range);
        int resFrom = range.getFrom();
        int resTo = range.getTo();
        if (!allIntersecting.isEmpty()) {
            Range tmp = allIntersecting.get(0).getKey();
            if (tmp.containsBoundary(resFrom)) {
                resFrom = Math.min(resFrom, tmp.getFrom());
            }
            if ((tmp = allIntersecting.get(allIntersecting.size() - 1).getKey()).containsBoundary(resTo)) {
                resTo = Math.max(resTo, tmp.getTo());
            }
        }
        Range rr = new Range(resFrom, resTo);
        S seq = this.provider.getRegion(rr);
        for (Map.Entry<Range, S> e : allIntersecting) {
            int length = e.getKey().length();
            Sequence s = (Sequence)e.getValue();
            int i = 0;
            int j = e.getKey().getFrom() - rr.getFrom();
            while (i < length) {
                if (((Sequence)seq).codeAt(j) != s.codeAt(i)) {
                    throw new IllegalStateException("Inconsistent sequence returned by provider.");
                }
                ++i;
                ++j;
            }
            this.sequences.remove(e.getKey());
        }
        this.sequences.put(rr, seq);
        return new AbstractMap.SimpleEntry<Range, S>(rr, seq);
    }

    public Set<Map.Entry<Range, S>> entrySet() {
        return this.sequences.entrySet();
    }

    @Override
    public int size() {
        if (this.provider instanceof NoProvider) {
            int s = this.provider.size();
            if (s >= 0) {
                return s;
            }
            if (this.sequences.isEmpty()) {
                throw new IllegalArgumentException(((NoProvider)this.provider).errorMessage);
            }
            return this.sequences.enclosingRange().getUpper();
        }
        if (this.provider instanceof SequenceProviderUtils.LazySequenceProvider) {
            if (this.sequences.isEmpty()) {
                return this.provider.size();
            }
            return this.sequences.enclosingRange().getUpper();
        }
        return this.provider.size();
    }

    @Override
    public S getRegion(Range range) {
        if (range.isEmpty()) {
            return this.alphabet.getEmptySequence();
        }
        Map.Entry<Range, S> entry = range.isReverse() ? this.ensureEntry(range.inverse()) : this.ensureEntry(range);
        return (S)((Sequence)((Sequence)entry.getValue()).getRange(entry.getKey().getRelativeRangeOf(range)));
    }

    public void setRegion(Range range, S seq) {
        int providerSize;
        if ((this.provider instanceof NoProvider && this.provider.size() > 0 || this.provider instanceof SequenceProviderUtils.LazySequenceProvider && ((SequenceProviderUtils.LazySequenceProvider)this.provider).isInitialized() || !(this.provider instanceof NoProvider) && !(this.provider instanceof SequenceProviderUtils.LazySequenceProvider)) && (providerSize = this.provider.size()) >= 0 && range.getUpper() > providerSize) {
            throw new IllegalArgumentException("Trying to set sequence outside available range.");
        }
        Map.Entry<Range, S> containing = this.sequences.findContaining(range);
        if (containing != null) {
            int i = 0;
            int j = range.getFrom() - containing.getKey().getFrom();
            while (i < seq.size()) {
                if (((Sequence)seq).codeAt(i) != ((Sequence)containing.getValue()).codeAt(j)) {
                    throw new IllegalStateException("Inconsistent sequence returned by provider.");
                }
                ++i;
                ++j;
            }
            return;
        }
        if (range.isReverse()) {
            throw new IllegalArgumentException("Don't support ");
        }
        List<Map.Entry<Range, S>> allIntersecting = this.sequences.findAllIntersectingOrTouching(range);
        int resFrom = range.getFrom();
        int resTo = range.getTo();
        if (!allIntersecting.isEmpty()) {
            Range tmp = allIntersecting.get(0).getKey();
            if (tmp.containsBoundary(resFrom)) {
                resFrom = Math.min(resFrom, tmp.getFrom());
            }
            if ((tmp = allIntersecting.get(allIntersecting.size() - 1).getKey()).containsBoundary(resTo)) {
                resTo = Math.max(resTo, tmp.getTo());
            }
        }
        if (seq.size() < resTo - resFrom) {
            Map.Entry<Range, S> entry;
            SequenceBuilder<Sequence> builder = this.alphabet.createBuilder().ensureCapacity(resTo - resFrom);
            if (range.getFrom() > resFrom) {
                entry = allIntersecting.get(0);
                assert (resFrom == entry.getKey().getFrom());
                builder.append((Sequence)((Sequence)entry.getValue()).getRange(0, range.getFrom() - entry.getKey().getFrom()));
            }
            builder.append((Sequence)seq);
            if (range.getTo() < resTo) {
                entry = allIntersecting.get(allIntersecting.size() - 1);
                assert (resTo == entry.getKey().getTo());
                builder.append((Sequence)((Sequence)entry.getValue()).getRange(range.getTo() - entry.getKey().getFrom(), ((Sequence)entry.getValue()).size()));
            }
            seq = builder.createAndDestroy();
            range = new Range(resFrom, resTo);
        }
        for (Map.Entry<Range, S> e : allIntersecting) {
            int length = e.getKey().length();
            Sequence s = (Sequence)e.getValue();
            int i = 0;
            int j = e.getKey().getFrom() - range.getFrom();
            while (i < length) {
                if (((Sequence)seq).codeAt(j) != s.codeAt(i)) {
                    throw new IllegalStateException("Inconsistent sequence returned by provider.");
                }
                ++i;
                ++j;
            }
            this.sequences.remove(e.getKey());
        }
        this.sequences.put(range, seq);
    }

    private static final class NoProvider<S extends Sequence<S>>
    implements SequenceProvider<S> {
        final int size;
        final String errorMessage;

        public NoProvider(int size) {
            this(size, "No sequence provider");
        }

        public NoProvider(int size, String errorMessage) {
            this.size = size;
            this.errorMessage = errorMessage;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public S getRegion(Range range) {
            throw new IndexOutOfBoundsException(this.errorMessage + " (query range = " + range + ")");
        }
    }
}

