/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence.provider;

import com.milaboratory.core.Range;
import com.milaboratory.core.sequence.NucleotideSequence;
import com.milaboratory.core.sequence.Sequence;
import com.milaboratory.core.sequence.provider.SequenceProvider;
import com.milaboratory.core.sequence.provider.SequenceProviderFactory;
import com.milaboratory.core.sequence.provider.SequenceProviderIndexOutOfBoundsException;

public final class SequenceProviderUtils {
    private SequenceProviderUtils() {
    }

    public static SequenceProvider<NucleotideSequence> reversedProvider(SequenceProvider<NucleotideSequence> provider) {
        return new SubSequenceProvider<NucleotideSequence>(new Range(provider.size(), 0), provider);
    }

    public static <S extends Sequence<S>> SequenceProvider<S> subProvider(SequenceProvider<S> provider, Range targetRange) {
        return new SubSequenceProvider<S>(targetRange, provider);
    }

    public static <S extends Sequence<S>> SequenceProvider<S> fromSequence(final S sequence) {
        return new SequenceProvider<S>(){

            @Override
            public int size() {
                return sequence.size();
            }

            @Override
            public S getRegion(Range range) {
                if (range.getUpper() > sequence.size()) {
                    throw new SequenceProviderIndexOutOfBoundsException(range.intersection(new Range(0, sequence.size())));
                }
                return (Sequence)sequence.getRange(range);
            }
        };
    }

    public static <S extends Sequence<S>> SequenceProvider<S> lazyProvider(SequenceProviderFactory<S> factory) {
        return new LazySequenceProvider<S>(factory);
    }

    public static class LazySequenceProvider<S extends Sequence<S>>
    implements SequenceProvider<S> {
        private final SequenceProviderFactory<S> factory;
        volatile SequenceProvider<S> innerProvider;

        public LazySequenceProvider(SequenceProviderFactory<S> factory) {
            this.factory = factory;
            this.innerProvider = null;
        }

        public boolean isInitialized() {
            return this.innerProvider != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ensureProvider() {
            if (this.innerProvider == null) {
                LazySequenceProvider lazySequenceProvider = this;
                synchronized (lazySequenceProvider) {
                    if (this.innerProvider == null) {
                        this.innerProvider = this.factory.create();
                    }
                }
            }
        }

        @Override
        public int size() {
            this.ensureProvider();
            return this.innerProvider.size();
        }

        @Override
        public S getRegion(Range range) {
            this.ensureProvider();
            return this.innerProvider.getRegion(range);
        }
    }

    private static final class SubSequenceProvider<S extends Sequence<S>>
    implements SequenceProvider<S> {
        final Range targetRange;
        final SequenceProvider<S> provider;

        public SubSequenceProvider(Range targetRange, SequenceProvider<S> provider) {
            if (provider instanceof SubSequenceProvider) {
                this.targetRange = ((SubSequenceProvider)provider).targetRange.getAbsoluteRangeFor(targetRange);
                this.provider = ((SubSequenceProvider)provider).provider;
            } else {
                this.targetRange = targetRange;
                this.provider = provider;
            }
        }

        @Override
        public int size() {
            return this.targetRange.length();
        }

        @Override
        public S getRegion(Range range) {
            return this.provider.getRegion(this.targetRange.getAbsoluteRangeFor(range));
        }
    }
}

