/*
 * Decompiled with CFR 0.152.
 */
package com.milaboratory.core.sequence.quality;

import com.milaboratory.core.sequence.SequenceQuality;
import com.milaboratory.core.sequence.quality.QualityAggregator;

public class AverageQualityAggregator
implements QualityAggregator {
    private static final long OVERFLOW = -1L;
    final int size;
    byte state = 0;
    long[] data;

    public AverageQualityAggregator(int size) {
        this.size = size;
        this.data = new long[this.arraySize()];
    }

    private int arraySize() {
        return this.size + 1 + (7 >> this.state) >> 3 - this.state;
    }

    @Override
    public void aggregate(SequenceQuality quality) {
        if (quality.size() != this.size) {
            throw new IllegalArgumentException();
        }
        int segments = this.arraySize();
        switch (this.state) {
            case 0: {
                for (int i = 0; i < segments; ++i) {
                    long tmp = this.encode(quality, i);
                    if ((tmp = AverageQualityAggregator.add0(tmp, this.data[i])) == -1L) {
                        --i;
                        while (i >= 0) {
                            int n = i;
                            this.data[n] = this.data[n] - this.encode(quality, i);
                            --i;
                        }
                        this.state = 1;
                        long[] newData = new long[this.arraySize()];
                        for (int j = 0; j < this.data.length; ++j) {
                            newData[j * 2] = 0L | (0xFF00000000000000L & this.data[j]) >>> 8 | (0xFF000000000000L & this.data[j]) >>> 16 | (0xFF0000000000L & this.data[j]) >>> 24 | (0xFF00000000L & this.data[j]) >>> 32;
                            if (newData.length <= j * 2 + 1) continue;
                            newData[j * 2 + 1] = 0L | (0xFF000000L & this.data[j]) << 24 | (0xFF0000L & this.data[j]) << 16 | (0xFF00L & this.data[j]) << 8 | 0xFFL & this.data[j];
                        }
                        this.data = newData;
                        this.aggregate(quality);
                        return;
                    }
                    this.data[i] = tmp;
                }
                return;
            }
            case 1: {
                for (int i = 0; i < segments; ++i) {
                    long tmp = this.encode(quality, i);
                    if ((tmp = AverageQualityAggregator.add1(tmp, this.data[i])) == -1L) {
                        --i;
                        while (i >= 0) {
                            int n = i;
                            this.data[n] = this.data[n] - this.encode(quality, i);
                            --i;
                        }
                        this.state = (byte)2;
                        long[] newData = new long[this.arraySize()];
                        for (int j = 0; j < this.data.length; ++j) {
                            newData[j * 2] = 0L | (0xFFFF000000000000L & this.data[j]) >>> 16 | (0xFFFF00000000L & this.data[j]) >>> 32;
                            if (newData.length <= j * 2 + 1) continue;
                            newData[j * 2 + 1] = 0L | (0xFFFF0000L & this.data[j]) << 16 | 0xFFFFL & this.data[j];
                        }
                        this.data = newData;
                        this.aggregate(quality);
                        return;
                    }
                    this.data[i] = tmp;
                }
                return;
            }
            case 2: {
                for (int i = 0; i < segments; ++i) {
                    long tmp = this.encode(quality, i);
                    if ((tmp = AverageQualityAggregator.add2(tmp, this.data[i])) == -1L) {
                        --i;
                        while (i >= 0) {
                            int n = i;
                            this.data[n] = this.data[n] - this.encode(quality, i);
                            --i;
                        }
                        this.state = (byte)3;
                        long[] newData = new long[this.arraySize()];
                        for (int j = 0; j < this.data.length; ++j) {
                            newData[j * 2] = (0xFFFFFFFF00000000L & this.data[j]) >>> 32;
                            if (newData.length <= j * 2 + 1) continue;
                            newData[j * 2 + 1] = (0xFFFFFFFFL & this.data[j]) << 32;
                        }
                        this.data = newData;
                        this.aggregate(quality);
                        return;
                    }
                    this.data[i] = tmp;
                }
                return;
            }
            case 3: {
                for (int i = 0; i < segments; ++i) {
                    this.data[i] = AverageQualityAggregator.add3(this.encode(quality, i), this.data[i]);
                }
                return;
            }
        }
    }

    long encode(SequenceQuality quality, int segment) {
        int i;
        long result = segment == 0 ? 1L : 0L;
        int shift = 8 << this.state;
        int k = (segment << 3 - this.state) - 1 + (int)result;
        for (i = (8 >> this.state) - (int)result; i > 0 && k < quality.size(); --i) {
            result <<= shift;
            result |= (long)(0xFF & quality.value(k++));
        }
        return result <<= shift * i;
    }

    public byte getState() {
        return this.state;
    }

    long getCount() {
        long mask = -1L >>> 64 - (8 << this.state);
        return mask & this.data[0] >>> ((0xFFFFFFFF & 7 >> this.state) << this.state + 3);
    }

    long getTotal(int index) {
        long mask = -1L >>> 64 - (8 << this.state);
        return mask & this.data[++index >>> 3 - this.state] >>> ((~index & 7 >> this.state) << this.state + 3);
    }

    public static long add0(long a, long b) {
        long result = a + b;
        if (((result ^ a ^ b) & 0x101010101010100L) != 0L || (a >>> 56) + (b >>> 56) >= 256L) {
            return -1L;
        }
        return result;
    }

    public static long add1(long a, long b) {
        long result = a + b;
        if (((result ^ a ^ b) & 0x1000100010000L) != 0L || (a >>> 48) + (b >>> 48) >= 65536L) {
            return -1L;
        }
        return result;
    }

    public static long add2(long a, long b) {
        long result = a + b;
        if (((result ^ a ^ b) & 0x100000000L) != 0L || (a >>> 32) + (b >>> 32) >= 0x100000000L) {
            return -1L;
        }
        return result;
    }

    public static long add3(long a, long b) {
        return a + b;
    }

    @Override
    public SequenceQuality getQuality() {
        byte[] result = new byte[this.size];
        long count = this.getCount();
        for (int i = 0; i < this.size; ++i) {
            result[i] = (byte)((this.getTotal(i) + count / 2L) / count);
        }
        return new SequenceQuality(result);
    }
}

